/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.serialization.mappings.StopTimeFieldMappingFactory;
import org.onebusaway.transit_data_federation.impl.shapes.PointAndIndex;
import org.onebusaway.transit_data_federation.impl.transit_graph.DistanceAlongShapeLibrary;
import org.onebusaway.transit_data_federation.impl.transit_graph.StopEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.StopTimeEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TripEntryImpl;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.utility.InterpolationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StopTimeEntriesFactory {
    private static final boolean DEFAULT_LENIENT_MODE = true;
    private static final boolean DEFAULT_TIMEPOINT_SUPPORT = false;
    private Logger _log = LoggerFactory.getLogger(StopTimeEntriesFactory.class);
    private DistanceAlongShapeLibrary _distanceAlongShapeLibrary;
    private long _invalidStopToShapeMappingExceptionCount;
    private boolean isLenientArrivalDepartureTimes = true;
    private boolean removeTimePoints = true;

    @ConfigurationParameter
    public void setLenientArrivalDepartureTimes(boolean isLenient) {
        this.isLenientArrivalDepartureTimes = isLenient;
    }

    @Autowired
    public void setDistanceAlongShapeLibrary(DistanceAlongShapeLibrary distanceAlongShapeLibrary) {
        this._distanceAlongShapeLibrary = distanceAlongShapeLibrary;
    }

    public long getInvalidStopToShapeMappingExceptionCount() {
        return this._invalidStopToShapeMappingExceptionCount;
    }

    public List<StopTimeEntry> processStopTimes(TransitGraphImpl graph, List<StopTime> stopTimes, TripEntryImpl tripEntry, ShapePoints shapePoints) {
        ArrayList<StopTime> newStopTimes = new ArrayList<StopTime>(stopTimes.size());
        for (StopTime stopTime : stopTimes) {
            if (stopTime != null && stopTime.getStop() != null && stopTime.getStop().getId() != null) {
                newStopTimes.add(stopTime);
                continue;
            }
            this._log.error("found stopTime without a stop id for tripEntry=" + tripEntry + "(" + (Serializable)((Object)(stopTime.getTrip() == null ? "NuLl" : stopTime.getTrip().getId())) + "); stop=" + stopTime.getStopHeadsign() + ":" + StopTimeFieldMappingFactory.getSecondsAsString((int)stopTime.getArrivalTime()) + ":" + StopTimeFieldMappingFactory.getSecondsAsString((int)stopTime.getDepartureTime()) + ":" + stopTime.getRouteShortName() + "; route=" + (Serializable)((Object)(tripEntry.getRoute() == null ? "NuLl" : tripEntry.getRoute().getId())) + "; blockId=" + (Serializable)((Object)(tripEntry.getBlock() == null ? "NuLl" : tripEntry.getBlock().getId())) + "; stop=" + (String)(stopTime.getStop() == null ? "NuLl" : stopTime.getId() + ":" + stopTime.getRouteShortName()) + "; stopTime=" + stopTime.toString());
        }
        stopTimes = newStopTimes;
        Collections.sort(stopTimes, new StopTimeComparator());
        if (this.removeTimePoints) {
            stopTimes = this.removeTimePoints(stopTimes);
        }
        List<StopTimeEntry> stopTimeEntries = this.createInitialStopTimeEntries(graph, stopTimes);
        for (StopTimeEntry stopTime : stopTimeEntries) {
            stopTime.setTrip(tripEntry);
            stopTime.setTotalStopsInTrip(stopTimeEntries.size());
        }
        this.ensureStopTimesHaveShapeDistanceTraveledSet(stopTimeEntries, shapePoints);
        this.removeDuplicateStopTimes(stopTimes);
        this.ensureStopTimesHaveTimesSet(stopTimes, stopTimeEntries);
        return stopTimeEntries;
    }

    private List<StopTime> removeTimePoints(List<StopTime> stopTimes) {
        ArrayList<StopTime> results = new ArrayList<StopTime>(stopTimes.size());
        for (StopTime st : stopTimes) {
            if (st.getDropOffType() == 1 && st.getPickupType() == 1) continue;
            results.add(st);
        }
        return results;
    }

    private void removeDuplicateStopTimes(List<StopTime> stopTimes) {
        Collections.sort(stopTimes, new StopTimeComparator());
        boolean stopTimeWasModified = false;
        StopTime lastUnmodifiedStopTime = null;
        for (StopTime stopTime : stopTimes) {
            stopTimeWasModified = false;
            if (lastUnmodifiedStopTime == null) {
                lastUnmodifiedStopTime = stopTime;
                continue;
            }
            if (lastUnmodifiedStopTime.isArrivalTimeSet() && stopTime.isArrivalTimeSet() && stopTime.getArrivalTime() == lastUnmodifiedStopTime.getArrivalTime()) {
                stopTime.clearArrivalTime();
                stopTimeWasModified = true;
            }
            if (lastUnmodifiedStopTime.isDepartureTimeSet() && stopTime.isDepartureTimeSet() && stopTime.getDepartureTime() == lastUnmodifiedStopTime.getDepartureTime()) {
                stopTime.clearDepartureTime();
                stopTimeWasModified = true;
            }
            if (stopTimeWasModified) continue;
            lastUnmodifiedStopTime = stopTime;
        }
    }

    private List<StopTimeEntry> createInitialStopTimeEntries(TransitGraphImpl graph, List<StopTime> stopTimes) {
        ArrayList<StopTimeEntry> stopTimeEntries = new ArrayList<StopTimeEntry>(stopTimes.size());
        int sequence = 0;
        for (StopTime stopTime : stopTimes) {
            if (stopTime == null) {
                this._log.error("Found null stopTime in stopTime=" + stopTimes);
                continue;
            }
            StopLocation stop = stopTime.getStop();
            if (stop == null) {
                this._log.error("Stop is null for stopTime" + stopTime.getId());
                continue;
            }
            if (stop.getId() == null) {
                this._log.error("Stop id is null for stopTime" + stopTime + ", stop=" + stop);
                continue;
            }
            AgencyAndId stopId = stop.getId();
            StopEntryImpl stopEntry = graph.getStopEntryForId(stopId);
            StopTimeEntryImpl stopTimeEntry = new StopTimeEntryImpl();
            stopTimeEntry.setId(stopTime.getId());
            stopTimeEntry.setSequence(sequence);
            stopTimeEntry.setGtfsSequence(stopTime.getStopSequence());
            stopTimeEntry.setDropOffType(stopTime.getDropOffType());
            stopTimeEntry.setPickupType(stopTime.getPickupType());
            stopTimeEntry.setStop(stopEntry);
            stopTimeEntries.add(stopTimeEntry);
            ++sequence;
        }
        return stopTimeEntries;
    }

    public void ensureStopTimesHaveShapeDistanceTraveledSet(List<StopTimeEntry> stopTimes, ShapePoints shapePoints) {
        boolean distanceTraveledSet = false;
        if (shapePoints != null && shapePoints.getDistTraveled() != null) {
            try {
                PointAndIndex[] stopTimePoints = this._distanceAlongShapeLibrary.getDistancesAlongShape(shapePoints, stopTimes);
                for (int i = 0; i < stopTimePoints.length; ++i) {
                    PointAndIndex pindex = stopTimePoints[i];
                    StopTimeEntry stopTime = stopTimes.get(i);
                    stopTime.setShapePointIndex(pindex.index);
                    stopTime.setShapeDistTraveled(pindex.distanceAlongShape);
                }
                distanceTraveledSet = true;
            }
            catch (DistanceAlongShapeLibrary.StopIsTooFarFromShapeException ex) {
                StopTimeEntry stopTime = ex.getStopTime();
                TripEntry trip = stopTime.getTrip();
                StopEntry stop = stopTime.getStop();
                AgencyAndId shapeId = trip.getShapeId();
                CoordinatePoint point = ex.getPoint();
                PointAndIndex pindex = ex.getPointAndIndex();
                this._log.warn("Stop is too far from shape: trip=" + trip.getId() + " stop=" + stop.getId() + " stopLat=" + stop.getStopLat() + " stopLon=" + stop.getStopLon() + " shapeId=" + shapeId + " shapePoint=" + point + " index=" + pindex.index + " distance=" + pindex.distanceFromTarget);
            }
            catch (DistanceAlongShapeLibrary.DistanceAlongShapeException ex) {
                ++this._invalidStopToShapeMappingExceptionCount;
            }
            catch (IllegalArgumentException iae) {
                this._log.warn("Stop has illegal coordinates along shapes=" + shapePoints);
            }
        }
        if (!distanceTraveledSet) {
            double d = 0.0;
            StopTimeEntry prev = null;
            for (StopTimeEntry stopTime : stopTimes) {
                if (prev != null) {
                    CoordinatePoint from = prev.getStop().getStopLocation();
                    CoordinatePoint to = stopTime.getStop().getStopLocation();
                    d += SphericalGeometryLibrary.distance((CoordinatePoint)from, (CoordinatePoint)to);
                }
                stopTime.setShapeDistTraveled(d);
                prev = stopTime;
            }
        }
    }

    private void ensureStopTimesHaveTimesSet(List<StopTime> stopTimes, List<StopTimeEntry> stopTimeEntries) {
        double[] distanceTraveled = this.getDistanceTraveledForStopTimes(stopTimeEntries);
        int[] arrivalTimes = new int[stopTimes.size()];
        int[] departureTimes = new int[stopTimes.size()];
        this.interpolateArrivalAndDepartureTimes(stopTimes, distanceTraveled, arrivalTimes, departureTimes);
        int sequence = 0;
        int accumulatedSlackTime = 0;
        StopTimeEntry prevStopTimeEntry = null;
        for (StopTimeEntry stopTimeEntry : stopTimeEntries) {
            int duration;
            int arrivalTime = arrivalTimes[sequence];
            int departureTime = departureTimes[sequence];
            stopTimeEntry.setArrivalTime(arrivalTime);
            stopTimeEntry.setDepartureTime(departureTime);
            stopTimeEntry.setAccumulatedSlackTime(accumulatedSlackTime);
            accumulatedSlackTime += stopTimeEntry.getDepartureTime() - stopTimeEntry.getArrivalTime();
            if (prevStopTimeEntry != null && (duration = stopTimeEntry.getArrivalTime() - prevStopTimeEntry.getDepartureTime()) < 0) {
                this._log.error("Invalid duration of " + duration + " for stopTime " + stopTimeEntry.getId() + " of " + stopTimeEntry.getArrivalTime() + " compared to previous stopTime departure " + prevStopTimeEntry.getId() + " of " + prevStopTimeEntry.getDepartureTime());
                throw new IllegalStateException();
            }
            prevStopTimeEntry = stopTimeEntry;
            ++sequence;
        }
    }

    private void interpolateArrivalAndDepartureTimes(List<StopTime> stopTimes, double[] distanceTraveled, int[] arrivalTimes, int[] departureTimes) {
        TreeMap<Double, Integer> scheduleTimesByDistanceTraveled = new TreeMap<Double, Integer>();
        this.populateArrivalAndDepartureTimesByDistanceTravelledForStopTimes(stopTimes, distanceTraveled, scheduleTimesByDistanceTraveled);
        for (int i = 0; i < stopTimes.size(); ++i) {
            StopLocation stop;
            StopTime stopTime = stopTimes.get(i);
            double d = distanceTraveled[i];
            boolean hasDeparture = stopTime.isDepartureTimeSet();
            boolean hasArrival = stopTime.isArrivalTimeSet();
            int departureTime = stopTime.getDepartureTime();
            int arrivalTime = stopTime.getArrivalTime();
            if (hasDeparture && !hasArrival) {
                arrivalTime = departureTime;
            } else if (hasArrival && !hasDeparture) {
                departureTime = arrivalTime;
            } else if (!hasArrival && !hasDeparture) {
                int t;
                arrivalTime = t = (departureTimes[i] = (int)InterpolationLibrary.interpolate(scheduleTimesByDistanceTraveled, (Number)d));
                departureTime = t;
            }
            departureTimes[i] = departureTime;
            arrivalTimes[i] = arrivalTime;
            if (departureTimes[i] < arrivalTimes[i]) {
                throw new IllegalStateException("departure time is less than arrival time for stop time with trip_id=" + stopTime.getTrip().getId() + " stop_sequence=" + stopTime.getStopSequence());
            }
            if (i <= 0 || arrivalTimes[i] >= departureTimes[i - 1]) continue;
            StopTime prevStopTime = stopTimes.get(i - 1);
            StopLocation prevStop = prevStopTime.getStop();
            if (prevStop.equals(stop = stopTime.getStop()) && arrivalTimes[i] == departureTimes[i - 1] - 1) {
                this._log.info("fixing decreasing passingTimes: stopTimeA=" + prevStopTime.getId() + " stopTimeB=" + stopTime.getId());
                arrivalTimes[i] = departureTimes[i - 1];
                if (departureTimes[i] >= arrivalTimes[i]) continue;
                departureTimes[i] = arrivalTimes[i];
                continue;
            }
            if (this.isLenientMode() && i > 0 && arrivalTimes[i] < arrivalTimes[i - 1] && departureTimes[i] < departureTimes[i - 1]) {
                int t0 = (int)InterpolationLibrary.interpolate(scheduleTimesByDistanceTraveled, (Number)distanceTraveled[i - 1]);
                int t1 = (int)InterpolationLibrary.interpolate(scheduleTimesByDistanceTraveled, (Number)distanceTraveled[i]);
                if (t1 < t0) {
                    int m = t0;
                    t0 = t1;
                    t1 = m;
                    this._log.warn("interpolation error");
                }
                this._log.warn("correcting arrival time of sequence " + (stopTime.getStopSequence() - 1) + ", " + stopTime.getStopSequence() + " of trip " + stopTime.getTrip().getId() + " as it was less than last departure time.  Arrival[" + (i - 1) + "] " + arrivalTimes[i - 1] + " now " + t0 + ", Arrival[" + i + "] " + arrivalTimes[i] + " now " + t1);
                int n = t0;
                departureTimes[i - 1] = n;
                arrivalTimes[i - 1] = n;
                arrivalTimes[i] = departureTimes[i] = t1;
                continue;
            }
            for (int x = 0; x < stopTimes.size(); ++x) {
                StopTime st = stopTimes.get(x);
                String msg = x + " " + st.getId() + " " + arrivalTimes[x] + " " + departureTimes[x];
                this._log.error(msg);
                System.err.println(msg);
            }
            String exceptionMessage = "arrival time is less than previous departure time for stop time  with isLenientArrivalDepartureTimes=" + this.isLenientArrivalDepartureTimes + " and trip_id=" + stopTime.getTrip().getId() + " stop_sequence=" + stopTime.getStopSequence() + ", arrivalTime=" + arrivalTimes[i] + ", departureTime=" + departureTimes[i] + (String)(i > 0 ? " arrivalTimes[" + (i - 1) + "]=" + arrivalTimes[i - 1] + ", departureTimes[" + (i - 1) + "]=" + departureTimes[i - 1] : " (i<1)");
            this._log.error(exceptionMessage);
            throw new IllegalStateException(exceptionMessage);
        }
    }

    private boolean isLenientMode() {
        return Boolean.TRUE.equals(this.isLenientArrivalDepartureTimes);
    }

    private double[] getDistanceTraveledForStopTimes(List<StopTimeEntry> stopTimeEntries) {
        double[] distances = new double[stopTimeEntries.size()];
        for (int i = 0; i < stopTimeEntries.size(); ++i) {
            StopTimeEntry stopTime = stopTimeEntries.get(i);
            distances[i] = stopTime.getShapeDistTraveled();
        }
        return distances;
    }

    private void populateArrivalAndDepartureTimesByDistanceTravelledForStopTimes(List<StopTime> stopTimes, double[] distances, SortedMap<Double, Integer> scheduleTimesByDistanceTraveled) {
        for (int i = 0; i < stopTimes.size(); ++i) {
            double d;
            StopTime stopTime = stopTimes.get(i);
            double arrivalDistance = d = distances[i];
            double departureDistance = d + 1.0E-6;
            if (!(stopTime.getArrivalTime() < 0 || scheduleTimesByDistanceTraveled.containsKey(arrivalDistance) && (Integer)scheduleTimesByDistanceTraveled.get(arrivalDistance) <= stopTime.getArrivalTime())) {
                scheduleTimesByDistanceTraveled.put(arrivalDistance, stopTime.getArrivalTime());
            }
            if (stopTime.getDepartureTime() < 0 || scheduleTimesByDistanceTraveled.containsKey(departureDistance) && (Integer)scheduleTimesByDistanceTraveled.get(departureDistance) >= stopTime.getDepartureTime()) continue;
            scheduleTimesByDistanceTraveled.put(departureDistance, stopTime.getDepartureTime());
        }
    }

    private static class StopTimeComparator
    implements Comparator<StopTime> {
        private StopTimeComparator() {
        }

        @Override
        public int compare(StopTime o1, StopTime o2) {
            return o1.getStopSequence() - o2.getStopSequence();
        }
    }
}

