/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.exceptions.NoSuchStopServiceException;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.model.transit_graph.DynamicGraph;
import org.onebusaway.transit_data_federation.model.transit_graph.TransitGraph;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.transit_graph.AgencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransitGraphDaoImpl
implements TransitGraphDao {
    private static final Logger _log = LoggerFactory.getLogger(TransitGraphDaoImpl.class);
    private FederatedTransitDataBundle _bundle;
    private TransitGraph _graph;
    private DynamicGraph _dynamicGraph;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @Autowired
    public void setDynamicGraph(DynamicGraph dynamicGraph) {
        this._dynamicGraph = dynamicGraph;
    }

    public void setTransitGraph(TransitGraph graph) {
        this._graph = graph;
    }

    @PostConstruct
    @Refreshable(dependsOn={"transitGraph"})
    public void setup() throws IOException, ClassNotFoundException {
        TransitGraphImpl newGraph = null;
        File path = this._bundle.getTransitGraphPath();
        if (path.exists()) {
            long start = System.currentTimeMillis();
            newGraph = (TransitGraphImpl)ObjectSerializationLibrary.readObject((File)path);
            long delta = System.currentTimeMillis() - start;
            _log.info("Transit Graph load in {}s", (Object)(delta / 1000L));
            newGraph.initialize();
        } else {
            newGraph = new TransitGraphImpl();
        }
        TransitGraphImpl oldGraph = (TransitGraphImpl)this._graph;
        this._graph = newGraph;
        if (oldGraph != null) {
            oldGraph.empty();
            oldGraph = null;
        }
    }

    @Override
    public List<AgencyEntry> getAllAgencies() {
        return this._graph.getAllAgencies();
    }

    @Override
    public AgencyEntry getAgencyForId(String id) {
        return this._graph.getAgencyForId(id);
    }

    @Override
    public List<StopEntry> getAllStops() {
        return this._graph.getAllStops();
    }

    @Override
    public StopEntry getStopEntryForId(AgencyAndId id) {
        return this._graph.getStopEntryForId(id);
    }

    @Override
    public StopEntry getStopEntryForId(AgencyAndId id, boolean throwExceptionIfNotFound) {
        StopEntry stop = this._graph.getStopEntryForId(id);
        if (stop == null && throwExceptionIfNotFound) {
            throw new NoSuchStopServiceException(AgencyAndIdLibrary.convertToString((AgencyAndId)id));
        }
        return stop;
    }

    @Override
    public List<StopEntry> getStopsByLocation(CoordinateBounds bounds) {
        return this._graph.getStopsByLocation(bounds);
    }

    @Override
    public List<BlockEntry> getAllBlocks() {
        return this._graph.getAllBlocks();
    }

    @Override
    public BlockEntry getBlockEntryForId(AgencyAndId blockId) {
        return this._graph.getBlockEntryForId(blockId);
    }

    @Override
    public List<TripEntry> getAllTrips() {
        return this._graph.getAllTrips();
    }

    @Override
    public TripEntry getTripEntryForId(AgencyAndId id) {
        TripEntry entry = this._graph.getTripEntryForId(id);
        if (entry == null && this._dynamicGraph != null) {
            entry = this._dynamicGraph.getTripEntryForId(id);
        }
        return entry;
    }

    @Override
    public List<RouteCollectionEntry> getAllRouteCollections() {
        return this._graph.getAllRouteCollections();
    }

    @Override
    public RouteCollectionEntry getRouteCollectionForId(AgencyAndId id) {
        return this._graph.getRouteCollectionForId(id);
    }

    @Override
    public List<RouteEntry> getAllRoutes() {
        return this._graph.getAllRoutes();
    }

    @Override
    public RouteEntry getRouteForId(AgencyAndId id) {
        return this._graph.getRouteForId(id);
    }
}

