/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SearchResult<T> {
    private List<T> _results;
    private double[] _scores;

    public SearchResult() {
        this._results = Collections.emptyList();
        this._scores = new double[0];
    }

    public SearchResult(List<T> results, double[] scores) {
        this._results = results;
        this._scores = scores;
    }

    public int size() {
        return this._results.size();
    }

    public T getResult(int index) {
        return this._results.get(index);
    }

    public List<T> getResults() {
        return this._results;
    }

    public List<T> getResultsByTopScore() {
        if (this._scores == null || this._scores.length == 0) {
            return this._results;
        }
        ArrayList<ScoredResult<T>> sortedElements = new ArrayList<ScoredResult<T>>();
        for (int i = 0; i < this._results.size(); ++i) {
            sortedElements.add(new ScoredResult<T>(this._results.get(i), this._scores[i]));
        }
        Collections.sort(sortedElements, new TopScoreComparator());
        ArrayList sortedIds = new ArrayList();
        for (ScoredResult scoredResult : sortedElements) {
            sortedIds.add(scoredResult.getResult());
        }
        return sortedIds;
    }

    public double getScore(int index) {
        return this._scores[index];
    }

    public class TopScoreComparator<T>
    implements Comparator<T> {
        @Override
        public int compare(T a, T b) {
            ScoredResult sra = (ScoredResult)a;
            ScoredResult srb = (ScoredResult)b;
            return Double.compare(sra.getScore(), srb.getScore());
        }
    }

    public class ScoredResult<T> {
        private T _result;
        private double _score;

        public ScoredResult(T aresult, double ascore) {
            this._result = aresult;
            this._score = ascore;
        }

        public T getResult() {
            return this._result;
        }

        public double getScore() {
            return this._score;
        }
    }
}

