/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data.services.IntervalFactory;

public class WebIntervalFactory
implements IntervalFactory {
    private Map<ServiceDate, AgencyServiceInterval> _beanByServiceDate = new HashMap<ServiceDate, AgencyServiceInterval>();
    private Map<String, Integer> _overrides = new HashMap<String, Integer>();
    private int _binWidthInMillis = 900000;

    public void setBinWidthInMillis(int widthInMillis) {
        this._binWidthInMillis = widthInMillis;
    }

    public void setOverrides(Map<String, Integer> overrides) {
        this._overrides = overrides;
    }

    public AgencyServiceInterval constructForDate(Date date) {
        ServiceDate serviceDate = new ServiceDate(date);
        AgencyServiceInterval agencyInterval = this._beanByServiceDate.get(serviceDate);
        if (agencyInterval == null) {
            agencyInterval = new AgencyServiceInterval(this.binDate(date.getTime()), this._overrides);
            this._beanByServiceDate.put(serviceDate, agencyInterval);
        }
        return agencyInterval;
    }

    public AgencyServiceInterval constructDefault() {
        return this.constructForDate(new Date());
    }

    private long binDate(long time) {
        return new Double(Math.floor(new Double(time) / (double)this._binWidthInMillis) * (double)this._binWidthInMillis).longValue();
    }
}

