/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.List;
import org.onebusaway.transit_data_federation.impl.transit_graph.BlockTripEntryImpl;
import org.onebusaway.transit_data_federation.services.blocks.HasBlockTrips;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicBlockTripEntryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlockTripIndex
implements HasBlockTrips {
    protected static Logger _log = LoggerFactory.getLogger(AbstractBlockTripIndex.class);
    protected final List<BlockTripEntry> _trips;

    public AbstractBlockTripIndex(List<BlockTripEntry> trips) {
        if (trips == null) {
            throw new IllegalArgumentException("trips is null");
        }
        if (trips.isEmpty()) {
            throw new IllegalArgumentException("trips is empty");
        }
        AbstractBlockTripIndex.checkTripsHaveSameServiceids(trips);
        this._trips = trips;
        for (BlockTripEntry trip : trips) {
            BlockTripEntry tripImpl;
            if (trip instanceof BlockTripEntryImpl) {
                tripImpl = (BlockTripEntryImpl)trip;
                ((BlockTripEntryImpl)tripImpl).setPattern(this);
                continue;
            }
            if (trip instanceof DynamicBlockTripEntryImpl) {
                tripImpl = (DynamicBlockTripEntryImpl)trip;
                ((DynamicBlockTripEntryImpl)tripImpl).setPattern(this);
                continue;
            }
            _log.warn("unknown implementation of BlockTripEntry=" + trip);
        }
    }

    @Override
    public List<BlockTripEntry> getTrips() {
        return this._trips;
    }

    @Override
    public ServiceIdActivation getServiceIds() {
        return this._trips.get(0).getBlockConfiguration().getServiceIds();
    }

    public int size() {
        return this._trips.size();
    }

    private static void checkTripsHaveSameServiceids(List<BlockTripEntry> trips) {
        ServiceIdActivation expected = trips.get(0).getBlockConfiguration().getServiceIds();
        for (int i = 1; i < trips.size(); ++i) {
            ServiceIdActivation actual = trips.get(i).getBlockConfiguration().getServiceIds();
            if (expected.equals(actual)) continue;
            throw new IllegalArgumentException("serviceIds mismatch: expected=" + expected + " actual=" + actual);
        }
    }
}

