/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.List;
import org.onebusaway.transit_data_federation.services.blocks.HasBlocks;
import org.onebusaway.transit_data_federation.services.blocks.ServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.blocks.TransitTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;

@TransitTimeIndex
public class BlockIndex
implements HasBlocks {
    private final List<BlockConfigurationEntry> _blocks;
    private final ServiceIntervalBlock _serviceIntervalBlock;

    public BlockIndex(List<BlockConfigurationEntry> blocks, ServiceIntervalBlock serviceIntervalBlock) {
        if (blocks == null) {
            throw new IllegalArgumentException("blocks is null");
        }
        if (blocks.isEmpty()) {
            throw new IllegalArgumentException("blocks is empty");
        }
        BlockIndex.checkBlocksHaveSameServiceids(blocks);
        this._blocks = blocks;
        this._serviceIntervalBlock = serviceIntervalBlock;
    }

    @Override
    public List<BlockConfigurationEntry> getBlocks() {
        return this._blocks;
    }

    @Override
    public ServiceIdActivation getServiceIds() {
        return this._blocks.get(0).getServiceIds();
    }

    public ServiceIntervalBlock getServiceIntervalBlock() {
        return this._serviceIntervalBlock;
    }

    public String toString() {
        return "BlockIndex [blocks=" + this._blocks + ", serviceIntervalBlock=" + this._serviceIntervalBlock + "]";
    }

    private static void checkBlocksHaveSameServiceids(List<BlockConfigurationEntry> blocks) {
        ServiceIdActivation expected = blocks.get(0).getServiceIds();
        for (int i = 1; i < blocks.size(); ++i) {
            ServiceIdActivation actual = blocks.get(i).getServiceIds();
            if (expected.equals(actual)) continue;
            throw new IllegalArgumentException("serviceIds mismatch: expected=" + expected + " actual=" + actual);
        }
    }
}

