/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import org.onebusaway.transit_data_federation.services.blocks.InstanceState;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;

public class BlockInstance {
    private final BlockConfigurationEntry _block;
    private final InstanceState _state;

    public BlockInstance(BlockConfigurationEntry block, long serviceDate) {
        this(block, serviceDate, null);
    }

    public BlockInstance(BlockConfigurationEntry block, long serviceDate, FrequencyEntry frequency) {
        this(block, new InstanceState(serviceDate, frequency));
    }

    public BlockInstance(BlockConfigurationEntry block, InstanceState state) {
        if (block == null || state == null) {
            throw new IllegalArgumentException();
        }
        this._block = block;
        this._state = state;
    }

    public BlockConfigurationEntry getBlock() {
        return this._block;
    }

    public InstanceState getState() {
        return this._state;
    }

    public long getServiceDate() {
        return this._state.getServiceDate();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._block.hashCode();
        result = 31 * result + this._state.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockInstance other = (BlockInstance)obj;
        if (!this._block.equals(other._block)) {
            return false;
        }
        return this._state.equals(other._state);
    }

    public String toString() {
        return this._block.toString() + " " + this._state;
    }
}

