/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.List;
import org.onebusaway.transit_data_federation.impl.blocks.BlockSequence;
import org.onebusaway.transit_data_federation.services.blocks.AbstractBlockSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.ServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.blocks.TransitTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;

@TransitTimeIndex
public class BlockSequenceIndex
extends AbstractBlockSequenceIndex {
    private final ServiceIntervalBlock _serviceIntervalBlock;

    public BlockSequenceIndex(List<BlockSequence> sequences, ServiceIntervalBlock serviceIntervalBlock, boolean privateService) {
        super(sequences, privateService);
        this._serviceIntervalBlock = serviceIntervalBlock;
    }

    public ServiceIntervalBlock getServiceIntervalBlock() {
        return this._serviceIntervalBlock;
    }

    public String toString() {
        BlockSequence first = (BlockSequence)this._sequences.get(0);
        BlockConfigurationEntry blockConfig = first.getBlockConfig();
        BlockEntry block = blockConfig.getBlock();
        List<BlockStopTimeEntry> bsts = first.getStopTimes();
        BlockStopTimeEntry firstBst = bsts.get(0);
        BlockStopTimeEntry lastBst = bsts.get(bsts.size() - 1);
        StopEntry fromStop = firstBst.getStopTime().getStop();
        StopEntry toStop = lastBst.getStopTime().getStop();
        return "BlockSequenceIndex [ex: block=" + block.getId() + " fromStop=" + fromStop.getId() + " toStop=" + toStop.getId() + " serviceIds=" + this.getServiceIds() + "]";
    }
}

