/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data_federation.services.blocks.AbstractBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.HasIndexedBlockStopTimes;
import org.onebusaway.transit_data_federation.services.blocks.TransitTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;

@TransitTimeIndex
public class BlockStopTimeIndex
extends AbstractBlockStopTimeIndex
implements HasIndexedBlockStopTimes {
    public static BlockStopTimeIndex create(BlockTripIndex blockTripIndex, int blockSequence) {
        List<BlockTripEntry> tripsList = blockTripIndex.getTrips();
        int n = tripsList.size();
        ArrayList<BlockConfigurationEntry> blockConfigs = new ArrayList<BlockConfigurationEntry>(n);
        for (BlockTripEntry trip : tripsList) {
            blockConfigs.add(trip.getBlockConfiguration());
        }
        int[] stopIndices = new int[n];
        Arrays.fill(stopIndices, blockSequence);
        ServiceInterval serviceInterval = BlockStopTimeIndex.computeServiceInterval(blockTripIndex, blockSequence);
        return new BlockStopTimeIndex(blockConfigs, stopIndices, serviceInterval);
    }

    public BlockStopTimeIndex(List<BlockConfigurationEntry> blockConfigs, int[] stopIndices, ServiceInterval serviceInterval) {
        super(blockConfigs, stopIndices, serviceInterval);
    }

    @Override
    public int getArrivalTimeForIndex(int index) {
        BlockConfigurationEntry blockConfig = (BlockConfigurationEntry)this._blockConfigs.get(index);
        int stopIndex = this._stopIndices[index];
        return blockConfig.getArrivalTimeForIndex(stopIndex);
    }

    @Override
    public int getDepartureTimeForIndex(int index) {
        BlockConfigurationEntry blockConfig = (BlockConfigurationEntry)this._blockConfigs.get(index);
        int stopIndex = this._stopIndices[index];
        return blockConfig.getDepartureTimeForIndex(stopIndex);
    }

    public double getDistanceAlongBlockForIndex(int index) {
        BlockConfigurationEntry blockConfig = (BlockConfigurationEntry)this._blockConfigs.get(index);
        int stopIndex = this._stopIndices[index];
        return blockConfig.getDistanceAlongBlockForIndex(stopIndex);
    }

    public OccupancyStatus getOccupancyForIndex(int index) {
        BlockConfigurationEntry blockConfig = (BlockConfigurationEntry)this._blockConfigs.get(index);
        int stopIndex = this._stopIndices[index];
        return blockConfig.getOccupancyForIndex(stopIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockStopTimeIndex other = (BlockStopTimeIndex)obj;
        if (this._blockConfigs.size() != other._blockConfigs.size()) {
            return false;
        }
        if (!this._blockConfigs.containsAll(other._blockConfigs)) {
            return false;
        }
        return Arrays.equals(this._stopIndices, other._stopIndices);
    }
}

