/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripReference;
import org.onebusaway.transit_data_federation.services.blocks.ReferencesLibrary;
import org.onebusaway.transit_data_federation.services.blocks.ServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;

public class BlockTripIndexData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<BlockTripReference> _blockTripReferences;
    private final ServiceIntervalBlock _serviceIntervalBlock;

    public BlockTripIndexData(List<BlockTripReference> blockTripReferences, ServiceIntervalBlock serviceIntervalBlock) {
        this._blockTripReferences = blockTripReferences;
        this._serviceIntervalBlock = serviceIntervalBlock;
    }

    public List<BlockTripReference> getBlockTripReferences() {
        return this._blockTripReferences;
    }

    public ServiceIntervalBlock getServiceIntervalBlock() {
        return this._serviceIntervalBlock;
    }

    public BlockTripIndex createIndex(TransitGraphDao dao) {
        ArrayList<BlockTripEntry> trips = new ArrayList<BlockTripEntry>();
        for (BlockTripReference blockTripReference : this._blockTripReferences) {
            BlockTripEntry trip = ReferencesLibrary.getReferenceAsTrip(blockTripReference, dao);
            trips.add(trip);
        }
        return new BlockTripIndex(trips, this._serviceIntervalBlock);
    }
}

