/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.AbstractList;
import java.util.List;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.transit_data_federation.impl.transit_graph.FrequencyBlockStopTimeEntryImpl;
import org.onebusaway.transit_data_federation.services.blocks.AbstractBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.HasIndexedFrequencyBlockTrips;
import org.onebusaway.transit_data_federation.services.blocks.TransitTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyBlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;

@TransitTimeIndex
public class FrequencyBlockStopTimeIndex
extends AbstractBlockStopTimeIndex
implements HasIndexedFrequencyBlockTrips {
    private final FrequencyBlockStopTimeList _frequencyStopTimes = new FrequencyBlockStopTimeList();
    private final List<FrequencyEntry> _frequencies;

    public FrequencyBlockStopTimeIndex(List<FrequencyEntry> frequencies, List<BlockConfigurationEntry> blockConfigs, int[] stopIndices, ServiceInterval serviceInterval) {
        super(blockConfigs, stopIndices, serviceInterval);
        this._frequencies = frequencies;
    }

    public List<FrequencyEntry> getFrequencies() {
        return this._frequencies;
    }

    @Override
    public int getStartTimeForIndex(int index) {
        return this._frequencies.get(index).getStartTime();
    }

    @Override
    public int getEndTimeForIndex(int index) {
        return this._frequencies.get(index).getEndTime();
    }

    public List<FrequencyBlockStopTimeEntry> getFrequencyStopTimes() {
        return this._frequencyStopTimes;
    }

    private class FrequencyBlockStopTimeList
    extends AbstractList<FrequencyBlockStopTimeEntry> {
        private FrequencyBlockStopTimeList() {
        }

        @Override
        public int size() {
            return FrequencyBlockStopTimeIndex.this.getStopTimes().size();
        }

        @Override
        public FrequencyBlockStopTimeEntry get(int index) {
            BlockStopTimeEntry blockStopTime = FrequencyBlockStopTimeIndex.this.getStopTimeForIndex(index);
            FrequencyEntry frequency = FrequencyBlockStopTimeIndex.this._frequencies.get(index);
            return new FrequencyBlockStopTimeEntryImpl(blockStopTime, frequency);
        }
    }
}

