/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.io.Serializable;
import java.util.Arrays;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;

public final class ServiceIntervalBlock
implements Serializable,
Comparable<ServiceIntervalBlock> {
    private static final long serialVersionUID = 1L;
    private final int[] minArrivals;
    private final int[] minDepartures;
    private final int[] maxArrivals;
    private final int[] maxDepartures;

    public ServiceIntervalBlock(int[] minArrivals, int[] minDepartures, int[] maxArrivals, int[] maxDepartures) {
        this.minArrivals = minArrivals;
        this.minDepartures = minDepartures;
        this.maxArrivals = maxArrivals;
        this.maxDepartures = maxDepartures;
        int n = minArrivals.length;
        if (n != minDepartures.length || n != maxArrivals.length || n != maxDepartures.length) {
            throw new IllegalArgumentException("arrays must have same length");
        }
    }

    public int[] getMinArrivals() {
        return this.minArrivals;
    }

    public int[] getMinDepartures() {
        return this.minDepartures;
    }

    public int[] getMaxArrivals() {
        return this.maxArrivals;
    }

    public int[] getMaxDepartures() {
        return this.maxDepartures;
    }

    public ServiceInterval getRange() {
        int n = this.maxArrivals.length - 1;
        return new ServiceInterval(this.minArrivals[0], this.minDepartures[0], this.maxArrivals[n], this.maxDepartures[n]);
    }

    @Override
    public int compareTo(ServiceIntervalBlock o) {
        return this.minArrivals[0] - o.minArrivals[0];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceIntervalBlock other = (ServiceIntervalBlock)obj;
        return Arrays.equals(this.minArrivals, other.minArrivals) && Arrays.equals(this.minDepartures, other.minDepartures) && Arrays.equals(this.maxArrivals, other.maxArrivals) && Arrays.equals(this.maxDepartures, other.maxDepartures);
    }
}

