/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.realtime;

import org.onebusaway.transit_data_federation.model.StopTimeInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.InstanceState;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrivalAndDepartureTime {
    private static Logger _log = LoggerFactory.getLogger(ArrivalAndDepartureTime.class);
    private long arrivalTime;
    private long departureTime;

    public ArrivalAndDepartureTime(long arrivalTime, long departureTime) {
        this.arrivalTime = arrivalTime;
        this.departureTime = departureTime;
    }

    public long getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(long arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public long getDepartureTime() {
        return this.departureTime;
    }

    public void setDepartureTime(long departureTime) {
        this.departureTime = departureTime;
    }

    public static ArrivalAndDepartureTime getScheduledTime(BlockInstance blockInstance, BlockStopTimeEntry blockStopTime) {
        return ArrivalAndDepartureTime.getScheduledTime(blockInstance, blockStopTime, 0);
    }

    public static ArrivalAndDepartureTime getScheduledTime(BlockInstance blockInstance, BlockStopTimeEntry blockStopTime, int offset) {
        return ArrivalAndDepartureTime.getScheduledTime(blockInstance.getServiceDate(), blockStopTime, offset);
    }

    public static ArrivalAndDepartureTime getScheduledTime(StopTimeInstance stopTimeInstance) {
        return ArrivalAndDepartureTime.getScheduledTime(stopTimeInstance.getServiceDate(), stopTimeInstance.getStopTime(), 0);
    }

    public static ArrivalAndDepartureTime getScheduledTime(InstanceState state, BlockStopTimeEntry blockStopTime) {
        return ArrivalAndDepartureTime.getScheduledTime(state.getServiceDate(), blockStopTime, 0);
    }

    public static ArrivalAndDepartureTime getScheduledTime(long serviceDate, BlockStopTimeEntry blockStopTime, int offset) {
        if (blockStopTime == null) {
            _log.error("blockStopTime is null");
            return null;
        }
        StopTimeEntry stopTime = blockStopTime.getStopTime();
        long arrivalTime = serviceDate + (long)((stopTime.getArrivalTime() + offset) * 1000);
        long departureTime = serviceDate + (long)((stopTime.getDepartureTime() + offset) * 1000);
        return new ArrivalAndDepartureTime(arrivalTime, departureTime);
    }
}

