/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.realtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.onebusaway.collections.Range;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleLocationCacheElements {
    private static Logger _log = LoggerFactory.getLogger(VehicleLocationCacheElements.class);
    private final BlockInstance _blockInstance;
    private final List<VehicleLocationCacheElement> _elements;

    public VehicleLocationCacheElements(BlockInstance blockInstance) {
        this._blockInstance = blockInstance;
        this._elements = Collections.emptyList();
    }

    public VehicleLocationCacheElements(BlockInstance blockInstance, VehicleLocationCacheElement element) {
        this._blockInstance = blockInstance;
        this._elements = Arrays.asList(element);
    }

    private VehicleLocationCacheElements(BlockInstance blockInstance, List<VehicleLocationCacheElement> elements) {
        this._blockInstance = blockInstance;
        this._elements = elements;
    }

    public VehicleLocationCacheElements extend(VehicleLocationCacheElement element) {
        VehicleLocationCacheElement lastElement;
        if (!this._elements.isEmpty() && (lastElement = this._elements.get(this._elements.size() - 1)).getRecord().getTimeOfRecord() > element.getRecord().getTimeOfRecord()) {
            _log.warn("ignoring vehicle location record with decreasing timestamp: " + lastElement.getRecord() + " => " + element.getRecord());
            return this;
        }
        ArrayList<VehicleLocationCacheElement> elements = new ArrayList<VehicleLocationCacheElement>(this._elements.size() + 1);
        elements.addAll(this._elements);
        elements.add(element);
        return new VehicleLocationCacheElements(this._blockInstance, elements);
    }

    public VehicleLocationCacheElements pruneOlderThanTime(long time) {
        if (this.isEmpty() || this._elements.get(0).getMeasuredLastUpdateTime() >= time) {
            return this;
        }
        ArrayList<VehicleLocationCacheElement> elements = new ArrayList<VehicleLocationCacheElement>();
        for (VehicleLocationCacheElement element : this._elements) {
            if (element.getMeasuredLastUpdateTime() < time) continue;
            elements.add(element);
        }
        return new VehicleLocationCacheElements(this._blockInstance, elements);
    }

    public BlockInstance getBlockInstance() {
        return this._blockInstance;
    }

    public boolean isEmpty() {
        return this._elements.isEmpty();
    }

    public Range getTimeRange() {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException();
        }
        VehicleLocationCacheElement first = this._elements.get(0);
        VehicleLocationCacheElement last = this._elements.get(this._elements.size() - 1);
        return new Range((double)first.getRecord().getTimeOfRecord(), (double)last.getRecord().getTimeOfRecord());
    }

    public List<VehicleLocationCacheElement> getElements() {
        return Collections.unmodifiableList(this._elements);
    }

    public VehicleLocationCacheElement getElementForTimestamp(long targetTime) {
        if (this._elements.isEmpty()) {
            return null;
        }
        for (int i = this._elements.size() - 1; i > 0; --i) {
            VehicleLocationCacheElement element = this._elements.get(i);
            VehicleLocationRecord record = element.getRecord();
            if (record.getTimeOfRecord() > targetTime) continue;
            return element;
        }
        return this._elements.get(0);
    }

    public VehicleLocationCacheElement getLastElement() {
        if (this._elements.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this._elements.get(this._elements.size() - 1);
    }
}

