/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.transit_graph;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.RouteStop;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteStopCollectionEntry
implements Serializable {
    private static Logger _log = LoggerFactory.getLogger(RouteStopCollectionEntry.class);
    private AgencyAndId routeId;
    private String id;
    private String name;
    private Collection<StopAndSequence> routeStops = new TreeSet<StopAndSequence>(new StopAndSequenceComparator());

    public void add(RouteStop routeStop) {
        try {
            char separator = '_';
            if (routeStop.getStopId().indexOf(separator) == -1) {
                separator = ':';
            }
            AgencyAndId stopId = AgencyAndIdLibrary.convertFromString((String)routeStop.getStopId(), (char)separator);
            this.routeStops.add(new StopAndSequence(stopId, routeStop.getStopSequence()));
        }
        catch (IllegalStateException ise) {
            _log.error("invalid stop " + routeStop.getStopId() + " not in AgencyAndId format");
        }
    }

    public AgencyAndId getRouteId() {
        return this.routeId;
    }

    public void setRouteId(AgencyAndId routeId) {
        this.routeId = routeId;
    }

    public Collection<StopAndSequence> getRouteStops() {
        return this.routeStops;
    }

    public void setRouteStops(Collection<StopAndSequence> routeStops) {
        this.routeStops.addAll(routeStops);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class StopAndSequenceComparator
    implements Comparator<StopAndSequence>,
    Serializable {
        @Override
        public int compare(StopAndSequence o1, StopAndSequence o2) {
            return o1.sequence - o2.sequence;
        }
    }

    public static class StopAndSequence
    implements Serializable {
        private AgencyAndId stopId;
        private int sequence;

        public StopAndSequence(AgencyAndId stopId, int sequence) {
            this.stopId = stopId;
            this.sequence = sequence;
        }

        public AgencyAndId getStopId() {
            return this.stopId;
        }

        public int getSequence() {
            return this.sequence;
        }
    }
}

