/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.transit_graph;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdListComparator;

public class ServiceIdActivation
implements Serializable,
Comparable<ServiceIdActivation> {
    private static final long serialVersionUID = 1L;
    private static ServiceIdListComparator _serviceIdListComparator = new ServiceIdListComparator();
    private final List<LocalizedServiceId> activeServiceIds;
    private final List<LocalizedServiceId> inactiveServiceIds;

    public ServiceIdActivation(LocalizedServiceId serviceId) {
        this(Arrays.asList(serviceId), ServiceIdActivation.empty());
    }

    public ServiceIdActivation(List<LocalizedServiceId> activeServiceIds, List<LocalizedServiceId> inactiveServiceIds) {
        if (activeServiceIds == null) {
            throw new IllegalArgumentException("activeServiceIds is null");
        }
        if (inactiveServiceIds == null) {
            throw new IllegalArgumentException("inactiveServiceIds is null");
        }
        if (activeServiceIds.isEmpty()) {
            throw new IllegalArgumentException("activeServiceIds is empty");
        }
        this.activeServiceIds = activeServiceIds;
        this.inactiveServiceIds = inactiveServiceIds;
    }

    public List<LocalizedServiceId> getActiveServiceIds() {
        return this.activeServiceIds;
    }

    public List<LocalizedServiceId> getInactiveServiceIds() {
        return this.inactiveServiceIds;
    }

    public TimeZone getTimeZone() {
        return this.activeServiceIds.get(0).getTimeZone();
    }

    @Override
    public int compareTo(ServiceIdActivation o) {
        int rc = _serviceIdListComparator.compare(this.activeServiceIds, o.activeServiceIds);
        if (rc != 0) {
            return rc;
        }
        return _serviceIdListComparator.compare(this.inactiveServiceIds, o.inactiveServiceIds);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.activeServiceIds.hashCode();
        result = 31 * result + this.inactiveServiceIds.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceIdActivation other = (ServiceIdActivation)obj;
        if (!this.activeServiceIds.equals(other.activeServiceIds)) {
            return false;
        }
        return this.inactiveServiceIds.equals(other.inactiveServiceIds);
    }

    public String toString() {
        return "active=" + this.activeServiceIds + " inactive=" + this.inactiveServiceIds;
    }

    private static final List<LocalizedServiceId> empty() {
        return Collections.emptyList();
    }
}

