/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.transit_graph.dynamic;

import java.io.Serializable;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicStopEntryImpl;

public class DynamicStopTimeEntryImpl
implements StopTimeEntry,
Serializable {
    private static final long serialVersionUID = 9L;
    private int _stopTimeId;
    private int _arrivalTime = -1;
    private int _departureTime = -1;
    private OccupancyStatus _historicalOccupancy;
    private int _sequence;
    private int _gtfsSequence;
    private int _dropOffType;
    private int _pickupType;
    private int _shapePointIndex = -1;
    private double _shapeDistTraveled = Double.NaN;
    private int _accumulatedSlackTime = 0;
    private int _totalStopsInTrip;
    private DynamicStopEntryImpl _stop;
    private TripEntry _trip;

    public void setId(int id) {
        this._stopTimeId = id;
    }

    @Override
    public void setArrivalTime(int arrivalTime) {
        this._arrivalTime = arrivalTime;
    }

    @Override
    public void setDepartureTime(int departureTime) {
        this._departureTime = departureTime;
    }

    public void setHistoricalOccupancy(OccupancyStatus historicalOccupancy) {
        this._historicalOccupancy = historicalOccupancy;
    }

    public DynamicStopTimeEntryImpl setTime(int time) {
        this._arrivalTime = time;
        this._departureTime = time;
        return this;
    }

    public void setSequence(int sequence) {
        this._sequence = sequence;
    }

    public void setGtfsSequence(int gtfsSequence) {
        this._gtfsSequence = gtfsSequence;
    }

    public void setDropOffType(int dropOffType) {
        this._dropOffType = dropOffType;
    }

    public void setPickupType(int pickupType) {
        this._pickupType = pickupType;
    }

    public DynamicStopTimeEntryImpl setStop(DynamicStopEntryImpl stop) {
        this._stop = stop;
        return this;
    }

    @Override
    public void setTrip(TripEntry trip) {
        this._trip = trip;
    }

    @Override
    public void setShapePointIndex(int shapePointIndex) {
        this._shapePointIndex = shapePointIndex;
    }

    public boolean isShapeDistTraveledSet() {
        return !Double.isNaN(this._shapeDistTraveled);
    }

    @Override
    public void setShapeDistTraveled(double shapeDistTraveled) {
        this._shapeDistTraveled = shapeDistTraveled;
    }

    @Override
    public void setAccumulatedSlackTime(int accumulatedSlackTime) {
        this._accumulatedSlackTime = accumulatedSlackTime;
    }

    @Override
    public void setTotalStopsInTrip(int totalStopsInTrip) {
        this._totalStopsInTrip = totalStopsInTrip;
    }

    @Override
    public int getId() {
        return this._stopTimeId;
    }

    @Override
    public int getArrivalTime() {
        return this._arrivalTime;
    }

    @Override
    public int getDepartureTime() {
        return this._departureTime;
    }

    @Override
    public OccupancyStatus getHistoricalOccupancy() {
        return this._historicalOccupancy;
    }

    @Override
    public int getSequence() {
        return this._sequence;
    }

    @Override
    public int getGtfsSequence() {
        return this._gtfsSequence;
    }

    @Override
    public int getDropOffType() {
        return this._dropOffType;
    }

    @Override
    public int getPickupType() {
        return this._pickupType;
    }

    @Override
    public DynamicStopEntryImpl getStop() {
        return this._stop;
    }

    @Override
    public TripEntry getTrip() {
        return this._trip;
    }

    @Override
    public int getShapePointIndex() {
        return this._shapePointIndex;
    }

    @Override
    public double getShapeDistTraveled() {
        return this._shapeDistTraveled;
    }

    @Override
    public int getSlackTime() {
        return this._departureTime - this._arrivalTime;
    }

    @Override
    public int getAccumulatedSlackTime() {
        return this._accumulatedSlackTime;
    }

    @Override
    public int getTotalStopsInTrip() {
        return this._totalStopsInTrip;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StopTimeEntry)) {
            return false;
        }
        StopTimeEntry ste = (StopTimeEntry)obj;
        return this._stopTimeId == ste.getId() && this._arrivalTime == ste.getArrivalTime() && this._departureTime == ste.getDepartureTime() && this._sequence == ste.getSequence();
    }

    public int hashCode() {
        return this._stopTimeId + this._arrivalTime + this._departureTime + this._sequence;
    }

    public String toString() {
        return "DynamicStopTimeEntryImpl(stop=" + this._stop.getId() + " trip=" + this._trip + " arrival=" + this._arrivalTime + " departure=" + this._departureTime + ")";
    }
}

