/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.transit_graph.dynamic;

import java.io.Serializable;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicBlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicRouteEntry;

public class DynamicTripEntryImpl
implements TripEntry,
Serializable {
    private static final long serialVersionUID = 7L;
    private AgencyAndId _id;
    private DynamicRouteEntry _route;
    private String _directionId;
    private DynamicBlockEntry _block;
    private LocalizedServiceId _serviceId;
    private AgencyAndId _shapeId;
    private List<StopTimeEntry> _stopTimes;
    private double _totalTripDistance;
    private FrequencyEntry _frequencyLabel;

    public DynamicTripEntryImpl setId(AgencyAndId id) {
        this._id = id;
        return this;
    }

    public DynamicTripEntryImpl setRoute(DynamicRouteEntry route) {
        this._route = route;
        return this;
    }

    public DynamicTripEntryImpl setDirectionId(String directionId) {
        this._directionId = directionId;
        return this;
    }

    @Override
    public TripEntry setBlock(BlockEntry block) {
        this._block = (DynamicBlockEntry)block;
        return this;
    }

    public DynamicTripEntryImpl setServiceId(LocalizedServiceId serviceId) {
        this._serviceId = serviceId;
        return this;
    }

    public void setShapeId(AgencyAndId shapeId) {
        this._shapeId = shapeId;
    }

    public void setStopTimes(List<StopTimeEntry> stopTimes) {
        this._stopTimes = stopTimes;
    }

    public void setTotalTripDistance(double totalTripDistance) {
        this._totalTripDistance = totalTripDistance;
    }

    public void setFrequencyLabel(FrequencyEntry frequencyLabel) {
        this._frequencyLabel = frequencyLabel;
    }

    @Override
    public AgencyAndId getId() {
        return this._id;
    }

    @Override
    public RouteEntry getRoute() {
        return this._route;
    }

    @Override
    public RouteCollectionEntry getRouteCollection() {
        return this._route.getParent();
    }

    @Override
    public String getDirectionId() {
        return this._directionId;
    }

    @Override
    public DynamicBlockEntry getBlock() {
        return this._block;
    }

    @Override
    public LocalizedServiceId getServiceId() {
        return this._serviceId;
    }

    @Override
    public AgencyAndId getShapeId() {
        return this._shapeId;
    }

    @Override
    public List<StopTimeEntry> getStopTimes() {
        return this._stopTimes;
    }

    @Override
    public double getTotalTripDistance() {
        return this._totalTripDistance;
    }

    @Override
    public FrequencyEntry getFrequencyLabel() {
        return this._frequencyLabel;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TripEntry)) {
            return false;
        }
        TripEntry trip = (TripEntry)obj;
        return this._id.equals((Object)trip.getId()) && this._serviceId.equals((Object)trip.getServiceId());
    }

    public int hashCode() {
        return this._id.hashCode() + this._serviceId.hashCode();
    }

    public String toString() {
        return "Trip(" + this._id + ")";
    }
}

