/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.siri;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.util.ReflectionUtils;
import uk.org.siri.siri.Siri;

public class SiriJsonSerializer {
    public String getJson(Siri siri) throws Exception {
        return this.getJson(siri, null);
    }

    public String getJson(Siri siri, String callback) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
        mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        mapper.setDateFormat((DateFormat)new RFC822SimpleDateFormat());
        SiriJacksonModule module = new SiriJacksonModule();
        mapper.registerModule((Module)module);
        mapper.registerModules(new Module[]{new JaxbAnnotationModule()});
        Object output = "";
        if (callback != null) {
            output = callback + "(";
        }
        output = (String)output + mapper.writeValueAsString((Object)siri);
        if (callback != null) {
            output = (String)output + ")";
        }
        return output;
    }

    private static class RFC822SimpleDateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;

        public RFC822SimpleDateFormat() {
            super("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            StringBuffer sb = super.format(date, toAppendTo, pos);
            sb.insert(sb.length() - 2, ":");
            return sb;
        }
    }

    private static class SiriJacksonModule
    extends Module {
        private static final Version VERSION = new Version(1, 0, 0, null);

        private SiriJacksonModule() {
        }

        public String getModuleName() {
            return "CustomSerializer";
        }

        public Version version() {
            return VERSION;
        }

        public void setupModule(Module.SetupContext context) {
            context.addBeanSerializerModifier((BeanSerializerModifier)new CustomBeanSerializerModifier());
        }
    }

    private static class CustomBeanSerializerModifier
    extends BeanSerializerModifier {
        private CustomBeanSerializerModifier() {
        }

        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (serializer instanceof BeanSerializer) {
                List properties = beanDesc.findProperties();
                for (BeanPropertyDefinition property : properties) {
                    String fieldName;
                    if (!property.getInternalName().equals("value") && !property.getInternalName().equals("any") || (fieldName = property.getInternalName()) == null) continue;
                    return super.modifySerializer(config, beanDesc, (JsonSerializer)new CustomValueObjectSerializer((BeanSerializer)serializer, fieldName));
                }
            }
            return super.modifySerializer(config, beanDesc, serializer);
        }
    }

    private static class CustomValueObjectSerializer
    extends BeanSerializerBase {
        private String fieldName = null;

        protected CustomValueObjectSerializer(BeanSerializer src, String fieldName) {
            super((BeanSerializerBase)src);
            this.fieldName = fieldName;
        }

        public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            try {
                Class<?> beanClass = bean.getClass();
                Field valueField = ReflectionUtils.findField(beanClass, (String)this.fieldName);
                valueField.setAccessible(true);
                Object value = valueField.get(bean);
                provider.defaultSerializeValue(value, jgen);
            }
            catch (Exception e) {
                jgen.writeNull();
            }
        }

        public BeanSerializerBase withObjectIdWriter(ObjectIdWriter var1) {
            return null;
        }

        public BeanSerializerBase withFilterId(Object var1) {
            return null;
        }

        protected BeanSerializerBase withProperties(BeanPropertyWriter[] beanPropertyWriters, BeanPropertyWriter[] beanPropertyWriters1) {
            return null;
        }

        protected BeanSerializerBase withIgnorals(Set<String> var1) {
            return null;
        }

        protected BeanSerializerBase withByNameInclusion(Set<String> set, Set<String> set1) {
            return null;
        }

        public BeanSerializerBase asArraySerializer() {
            return null;
        }
    }
}

