/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.siri;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import org.onebusaway.transit_data_federation.siri.SiriDistanceExtension;
import org.onebusaway.transit_data_federation.siri.SiriExtensionWrapper;
import uk.org.siri.siri.Siri;

public class SiriXmlSerializer {
    private JAXBContext context = null;

    public SiriXmlSerializer() {
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{Siri.class, SiriExtensionWrapper.class, SiriDistanceExtension.class});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getXml(Siri siri) throws Exception {
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)false);
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getMessage(), event.getLinkedException());
            }
        });
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        StringWriter output = new StringWriter();
        marshaller.marshal((Object)siri, (Writer)output);
        String outputAsString = ((Object)output).toString();
        outputAsString = outputAsString.replaceAll("<ns5:", "<");
        outputAsString = outputAsString.replaceAll("</ns5:", "</");
        outputAsString = outputAsString.replaceAll("xmlns:ns5", "xmlns");
        outputAsString = outputAsString.replaceAll("<siriExtensionWrapper>", "");
        outputAsString = outputAsString.replaceAll("</siriExtensionWrapper>", "");
        return outputAsString;
    }

    public Siri fromXml(String xml) throws JAXBException {
        Unmarshaller u = this.context.createUnmarshaller();
        Siri siri = (Siri)u.unmarshal((Reader)new StringReader(xml));
        return siri;
    }
}

