/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.siri;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.transit_data_federation.siri.SiriDistanceExtension;
import org.onebusaway.transit_data_federation.siri.SiriExtensionWrapper;
import org.onebusaway.transit_data_federation.siri.SiriPolyLinesExtension;
import org.onebusaway.transit_data_federation.siri.SiriUpcomingServiceExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri_2.Siri;

public class SiriXmlSerializerV2 {
    private JAXBContext context = null;
    private static Logger _log = LoggerFactory.getLogger(SiriXmlSerializerV2.class);

    public SiriXmlSerializerV2() {
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{Siri.class, SiriExtensionWrapper.class, SiriDistanceExtension.class, SiriUpcomingServiceExtension.class, SiriPolyLinesExtension.class});
        }
        catch (Exception e) {
            _log.error("Failed to Serialize Siri to XML", (Throwable)e);
        }
    }

    public String getXml(Siri siri) throws Exception {
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)false);
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                _log.error(event.getMessage(), event.getLinkedException());
                throw new RuntimeException(event.getMessage(), event.getLinkedException());
            }
        });
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        StringWriter output = new StringWriter();
        marshaller.marshal((Object)siri, (Writer)output);
        String outputAsString = ((Object)output).toString();
        String[] searchList = new String[]{"<siriExtensionWrapper>", "</siriExtensionWrapper>", "<siriUpcomingServiceExtension>", "</siriUpcomingServiceExtension>", "<siriPolyLinesExtension>", "</siriPolyLinesExtension>"};
        String[] replacementList = new String[]{"", "", "", "", "", ""};
        outputAsString = StringUtils.replaceEach((String)outputAsString, (String[])searchList, (String[])replacementList);
        return outputAsString;
    }
}

