/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.transit_data_federation.util.HttpServiceClient;
import org.onebusaway.transit_data_federation.util.RestApiLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceClientImpl
implements HttpServiceClient {
    private static Logger _log = LoggerFactory.getLogger(HttpServiceClientImpl.class);
    private String _hostname = null;
    private String _apiEndpointPath = "/api/";
    private int _port = 80;
    private RestApiLibrary _restApiLibrary;

    public HttpServiceClientImpl(String protocol, String hostname, Integer port, String path) {
        this._hostname = hostname;
        if (port != null) {
            this._port = port;
        }
        if (path != null) {
            this._apiEndpointPath = path;
        }
        _log.info("Rest Service hostname = " + this._hostname);
        if (!StringUtils.isBlank((String)this._hostname)) {
            this._restApiLibrary = new RestApiLibrary(protocol, this._hostname, this._port, this._apiEndpointPath);
        } else {
            _log.warn("No Rest URL given!");
        }
    }

    public HttpServiceClientImpl(String host, Integer port, String apiPrefix) {
        this("http", host, port, apiPrefix);
    }

    @Override
    public URL buildUrl(String baseObject, String ... params) throws Exception {
        return this._restApiLibrary.buildUrl(baseObject, params);
    }

    @Override
    public String log(String baseObject, String component, Integer priority, String message) {
        return this._restApiLibrary.log(baseObject, component, priority, message);
    }

    @Override
    public List<JsonObject> getItemsForRequest(String baseObject, String ... params) throws IOException {
        if (this._restApiLibrary == null) {
            return Collections.emptyList();
        }
        URL requestUrl = this._restApiLibrary.buildUrl(baseObject, params);
        _log.info("Requesting " + requestUrl);
        String responseJson = this._restApiLibrary.getContentsOfUrlAsString(requestUrl);
        return this._restApiLibrary.getJsonObjectsForString(responseJson);
    }

    @Override
    public List<Map<String, String>> getItems(String baseObject, String ... params) throws IOException {
        if (this._restApiLibrary == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        List<JsonObject> items = this.getItemsForRequest(baseObject, params);
        for (JsonObject item : items) {
            HashMap<String, String> m = new HashMap<String, String>();
            result.add(m);
            for (Map.Entry entry : item.entrySet()) {
                m.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return result;
    }

    @Override
    public String getItem(String baseObject, String key) throws IOException {
        List<Map<String, String>> items = this.getItems("config", "list");
        if (items == null) {
            return null;
        }
        for (Map<String, String> component : items) {
            if (!component.containsKey("key") || !key.equals(component.get("key"))) continue;
            return component.get("value");
        }
        return null;
    }
}

