/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.util.HashMap;
import org.onebusaway.users.services.ApiKeyPermissionService;
import org.onebusaway.users.services.UserService;
import org.onebusaway.util.SystemTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyPermissionServiceImpl
implements ApiKeyPermissionService {
    private HashMap<String, Long> _lastVisitForUser = new HashMap();
    private UserService _userService;

    @Autowired
    public void setUserService(UserService userService) {
        this._userService = userService;
    }

    @Override
    public ApiKeyPermissionService.Status getPermission(String key, String service) {
        Long minRequestInterval = this._userService.getMinApiRequestIntervalForKey(key, false);
        if (minRequestInterval == null) {
            return ApiKeyPermissionService.Status.UNAUTHORIZED;
        }
        long now = SystemTime.currentTimeMillis();
        Long lastVisit = this._lastVisitForUser.get(key);
        ApiKeyPermissionService.Status ok = ApiKeyPermissionService.Status.RATE_EXCEEDED;
        if (lastVisit == null || lastVisit + minRequestInterval <= now) {
            ok = ApiKeyPermissionService.Status.AUTHORIZED;
        }
        this._lastVisitForUser.put(key, now);
        return ok;
    }
}

