/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.onebusaway.users.model.UserRole;
import org.onebusaway.users.services.StandardAuthoritiesService;
import org.onebusaway.users.services.UserDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class StandardAuthoritiesServiceImpl
implements StandardAuthoritiesService {
    private UserDao _userDao;
    private final Map<String, GrantedAuthority> _standardAuthoritiesMap = new ConcurrentHashMap<String, GrantedAuthority>();
    private final Map<String, UserRole> _userRoles = new ConcurrentHashMap<String, UserRole>();

    StandardAuthoritiesServiceImpl() {
    }

    @Autowired
    public void setUserDao(UserDao userDao) {
        this._userDao = userDao;
    }

    @Transactional(readOnly=false)
    @PostConstruct
    public void bootstrap() {
        for (String auth : STANDARD_AUTHORITIES) {
            this.createStandardAuthority(auth);
        }
    }

    private GrantedAuthority createStandardAuthority(String name) {
        assert (!this._standardAuthoritiesMap.containsKey(name));
        assert (!this._userRoles.containsKey(name));
        UserRole role = this._userDao.getUserRoleForName(name);
        if (role == null) {
            role = new UserRole(name);
            this._userDao.saveOrUpdateUserRole(role);
        }
        this._userRoles.put(name, role);
        SimpleGrantedAuthority auth = new SimpleGrantedAuthority(name);
        this._standardAuthoritiesMap.put(name, (GrantedAuthority)auth);
        return auth;
    }

    @Override
    public GrantedAuthority getNameBasedAuthority(String name) {
        GrantedAuthority auth = this._standardAuthoritiesMap.get(name);
        if (null == auth) {
            return new SimpleGrantedAuthority(name);
        }
        return auth;
    }

    @Override
    public UserRole getUserRoleForName(String name) {
        return this._userRoles.get(name);
    }

    @Override
    public UserRole getAdministratorRole() {
        return this.getUserRoleForName("ROLE_ADMINISTRATOR");
    }

    @Override
    public UserRole getAnonymousRole() {
        return this.getUserRoleForName("ROLE_ANONYMOUS");
    }

    @Override
    public UserRole getUserRole() {
        return this.getUserRoleForName("ROLE_USER");
    }

    @Override
    public UserRole getReportingRole() {
        return this.getUserRoleForName("ROLE_REPORTING");
    }
}

