/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import org.onebusaway.users.impl.IndexedUserDetailsImpl;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.model.User;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.model.UserIndexKey;
import org.onebusaway.users.services.IndexedUserDetailsService;
import org.onebusaway.users.services.StandardAuthoritiesService;
import org.onebusaway.users.services.UserService;
import org.onebusaway.users.services.internal.UserLastAccessTimeService;
import org.onebusaway.util.SystemTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserDetailsServiceImpl
implements UserDetailsService,
IndexedUserDetailsService {
    private UserService _userService;
    private StandardAuthoritiesService _authoritiesService;
    private UserLastAccessTimeService _userLastAccessTimeService;

    @Autowired
    public void setUserService(UserService userService) {
        this._userService = userService;
    }

    @Autowired
    public void setAuthoritiesService(StandardAuthoritiesService authoritiesService) {
        this._authoritiesService = authoritiesService;
    }

    @Autowired
    public void setUserLastAccessTimeService(UserLastAccessTimeService userLastAccessTimeService) {
        this._userLastAccessTimeService = userLastAccessTimeService;
    }

    @Transactional
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        int index = username.indexOf(95);
        if (index == -1) {
            throw new UsernameNotFoundException("username did not take the form type_value: " + username);
        }
        String type = username.substring(0, index);
        String value = username.substring(index + 1);
        UserIndexKey key = new UserIndexKey(type, value);
        return this.getUserForIndexKey(key);
    }

    @Override
    @Transactional
    public IndexedUserDetails getUserForIndexKey(UserIndexKey key) throws UsernameNotFoundException, DataAccessException {
        UserIndex userIndex = this._userService.getUserIndexForId(key);
        if (userIndex == null) {
            throw new UsernameNotFoundException(key.toString());
        }
        this.setLastAccessTimeForUser(userIndex);
        return new IndexedUserDetailsImpl(this._authoritiesService, userIndex);
    }

    @Override
    public IndexedUserDetails getOrCreateUserForIndexKey(UserIndexKey key, String credentials, boolean isAnonymous) throws DataAccessException {
        UserIndex userIndex = this._userService.getOrCreateUserForIndexKey(key, credentials, isAnonymous);
        this.setLastAccessTimeForUser(userIndex);
        return new IndexedUserDetailsImpl(this._authoritiesService, userIndex);
    }

    private void setLastAccessTimeForUser(UserIndex userIndex) {
        User user = userIndex.getUser();
        this._userLastAccessTimeService.handleAccessForUser(user.getId(), SystemTime.currentTimeMillis());
    }

    @Override
    public void resetUserForIndexKey(UserIndexKey key) {
        UserIndex index = this._userService.getUserIndexForId(key);
        if (index != null) {
            this._userService.resetUser(index.getUser());
        }
    }
}

