/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.onebusaway.users.model.User;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.model.UserProperties;
import org.onebusaway.users.model.UserPropertiesV1;
import org.onebusaway.users.model.properties.UserPropertiesV2;
import org.onebusaway.users.model.properties.UserPropertiesV3;
import org.onebusaway.users.model.properties.UserPropertiesV4;
import org.onebusaway.users.services.UserPropertiesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(value="org.onebusaway.users.impl:name=UserPropertiesServiceVersionedInvocationHandler")
public class UserPropertiesServiceVersionedInvocationHandler
implements InvocationHandler {
    private static Logger _log = LoggerFactory.getLogger(UserPropertiesServiceVersionedInvocationHandler.class);
    private UserPropertiesService _userServiceV1;
    private UserPropertiesService _userServiceV2;
    private UserPropertiesService _userServiceV3;
    private UserPropertiesService _userServiceV4;
    private int _preferredVersion = -1;
    private AtomicInteger _v1References = new AtomicInteger();
    private AtomicInteger _v2References = new AtomicInteger();
    private AtomicInteger _v3References = new AtomicInteger();
    private AtomicInteger _v4References = new AtomicInteger();

    public void setUserPropertiesServiceV1(UserPropertiesService userServiceV1) {
        this._userServiceV1 = userServiceV1;
    }

    public void setUserPropertiesServiceV2(UserPropertiesService userServiceV2) {
        this._userServiceV2 = userServiceV2;
    }

    public void setUserPropertiesServiceV3(UserPropertiesService userServiceV3) {
        this._userServiceV3 = userServiceV3;
    }

    public void setUserPropertiesServiceV4(UserPropertiesService userServiceV4) {
        this._userServiceV4 = userServiceV4;
    }

    public void setPreferredVersion(int preferredVersion) {
        this._preferredVersion = preferredVersion;
    }

    @ManagedAttribute
    public int getV1References() {
        return this._v1References.get();
    }

    @ManagedAttribute
    public int getV2References() {
        return this._v2References.get();
    }

    @ManagedAttribute
    public int getV3References() {
        return this._v3References.get();
    }

    @ManagedAttribute
    public int getV4References() {
        return this._v4References.get();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        UserPropertiesService service = this.getServiceForUserArgs(args);
        return method.invoke((Object)service, args);
    }

    private UserPropertiesService getServiceForUserArgs(Object[] args) {
        if (this._preferredVersion != -1) {
            return this.getServiceForVersion(this._preferredVersion);
        }
        int maxVersion = 0;
        if (args != null) {
            for (Object arg : args) {
                int version;
                if (arg instanceof User) {
                    User user = (User)((Object)arg);
                    version = this.getPropertiesVersion(user);
                    maxVersion = Math.max(maxVersion, version);
                    continue;
                }
                if (!(arg instanceof UserIndex)) continue;
                UserIndex userIndex = (UserIndex)arg;
                version = this.getPropertiesVersion(userIndex.getUser());
                maxVersion = Math.max(maxVersion, version);
            }
        }
        return this.getServiceForVersion(maxVersion);
    }

    private int getPropertiesVersion(User user) {
        UserProperties props = user.getProperties();
        if (props instanceof UserPropertiesV1) {
            return 1;
        }
        if (props instanceof UserPropertiesV2) {
            return 2;
        }
        if (props instanceof UserPropertiesV3) {
            return 3;
        }
        if (props instanceof UserPropertiesV4) {
            return 4;
        }
        _log.warn("unknown user properties version: " + props.getClass());
        return 0;
    }

    private UserPropertiesService getServiceForVersion(int maxVersion) {
        switch (maxVersion) {
            default: {
                this._v1References.incrementAndGet();
                return this._userServiceV1;
            }
            case 2: {
                this._v2References.incrementAndGet();
                return this._userServiceV2;
            }
            case 3: {
                this._v3References.incrementAndGet();
                return this._userServiceV3;
            }
            case 4: 
        }
        this._v4References.incrementAndGet();
        return this._userServiceV4;
    }
}

