/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl.authentication;

import java.util.Collection;
import org.onebusaway.users.impl.authentication.LegacyMessageDigestPasswordEncoder;
import org.onebusaway.users.impl.authentication.LegacyPasswordEncoder;
import org.onebusaway.users.impl.authentication.SaltedUsernamePasswordAuthenticationToken;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.services.CurrentUserService;
import org.onebusaway.users.services.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetails;

public class SaltedDaoAuthenticationProvider
extends DaoAuthenticationProvider {
    private static final Logger _log = LoggerFactory.getLogger(SaltedDaoAuthenticationProvider.class);
    private static final String DEFAULT_VERSION_PREFIX = "v1|";
    private LegacyPasswordEncoder passwordEncoder = new LegacyPasswordEncoder("SHA-256", true);
    private GrantedAuthoritiesMapper authoritiesMapper = new NullAuthoritiesMapper();
    private UserService userService;
    private CurrentUserService currentUserService;
    private String versionPrefix = "v1|";

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    public void setCurrentUserService(CurrentUserService currentUserService) {
        this.currentUserService = currentUserService;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        super.setAuthoritiesMapper(authoritiesMapper);
        this.authoritiesMapper = authoritiesMapper;
    }

    public void setVersionPrefix(String prefix) {
        this.versionPrefix = prefix;
    }

    protected Authentication createSuccessAuthentication(Object principal, Authentication authentication, UserDetails user) {
        SaltedUsernamePasswordAuthenticationToken result = new SaltedUsernamePasswordAuthenticationToken(principal, authentication.getCredentials(), this.authoritiesMapper.mapAuthorities(user.getAuthorities()));
        result.setDetails(authentication.getDetails());
        return result;
    }

    public Authentication authenticate(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        SaltedUsernamePasswordAuthenticationToken result = null;
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        result = this.authenticateNow(authentication);
        if (principal instanceof IndexedUserDetails) {
            result.setDetails(principal);
        } else if (principal instanceof String && result.getDetails() == null) {
            result.setDetails(this.getUserDetailsService().loadUserByUsername((String)principal));
        }
        return result;
    }

    private SaltedUsernamePasswordAuthenticationToken authenticateNow(Authentication authentication) {
        Object details;
        UserDetails userDetails = null;
        Collection authorities = authentication.getAuthorities();
        if ((authorities == null || authorities.isEmpty()) && (details = authentication.getDetails()) != null) {
            if (details instanceof UserDetails) {
                userDetails = (UserDetails)details;
                authorities = userDetails.getAuthorities();
            } else {
                userDetails = this.getUserDetailsService().loadUserByUsername((String)authentication.getPrincipal());
                authorities = userDetails.getAuthorities();
            }
        }
        if (userDetails == null) {
            _log.error("unable to retrieve user details for user ", (Object)authentication.getName());
            return null;
        }
        String username = ((IndexedUserDetails)userDetails).getUserIndexKey().getValue();
        String encPassword = userDetails.getPassword();
        String rawPassword = (String)authentication.getCredentials();
        String proposedPassword = this.versionPrefix + this.passwordEncoder.encodePassword(username, rawPassword);
        if (!LegacyMessageDigestPasswordEncoder.PasswordEncoderUtils.equals(proposedPassword, encPassword)) {
            throw new BadCredentialsException("authentication failed for " + username);
        }
        return new SaltedUsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), this.authoritiesMapper.mapAuthorities(authorities));
    }

    public boolean supports(Class authentication) {
        return authentication == SaltedUsernamePasswordAuthenticationToken.class || authentication == UsernamePasswordAuthenticationToken.class;
    }

    protected void additionalAuthenticationChecks(UserDetails details, UsernamePasswordAuthenticationToken auth) throws AuthenticationException {
        super.additionalAuthenticationChecks(details, auth);
    }
}

