/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl.authentication;

import java.util.Collection;
import org.onebusaway.users.impl.authentication.SaltedSha256PasswordEncoder;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.services.CurrentUserService;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class SaltedUsernamePasswordAuthenticationToken
extends UsernamePasswordAuthenticationToken {
    private Object principal;
    private Object credentials;
    private CurrentUserService userService;

    SaltedUsernamePasswordAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
        this.principal = principal;
        this.credentials = credentials;
    }

    public Object getCredentials() {
        String salt = null;
        if (this.principal instanceof IndexedUserDetails) {
            IndexedUserDetails userDetails = (IndexedUserDetails)this.principal;
            salt = userDetails.getUsername();
        } else if (this.principal instanceof String) {
            salt = (String)this.principal;
        }
        SaltedSha256PasswordEncoder encoder = new SaltedSha256PasswordEncoder("SHA");
        return encoder.encodePassword(this.credentials.toString(), salt);
    }
}

