/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl.internal;

import java.io.Serializable;
import java.util.Date;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.onebusaway.users.model.User;
import org.onebusaway.users.services.UserDao;
import org.onebusaway.users.services.internal.UserLastAccessTimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserLastAccessTimeServiceImpl
implements UserLastAccessTimeService {
    private Logger _log = LoggerFactory.getLogger(UserLastAccessTimeServiceImpl.class);
    private UserDao _userDao;
    private Cache _cache;

    @Autowired
    public void setUserDao(UserDao userDao) {
        this._userDao = userDao;
    }

    public void setCache(Cache cache) {
        this._cache = cache;
    }

    public long getNumberOfActiveUsers() {
        return this._cache.getSize();
    }

    @Override
    public void handleAccessForUser(int userId, long accessTime) {
        Element element = this._cache.get((Serializable)Integer.valueOf(userId));
        if (element == null) {
            User user = this._userDao.getUserForId(userId);
            user.setLastAccessTime(new Date(accessTime));
            this._userDao.saveOrUpdateUser(user);
            if (this._log.isDebugEnabled()) {
                this._log.debug("user last access set " + userId);
            }
            element = new Element((Serializable)Integer.valueOf(userId), (Serializable)Long.valueOf(accessTime));
            this._cache.put(element);
        }
    }
}

