/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl.validation;

import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.onebusaway.users.services.validation.KeyValidationProvider;
import org.onebusaway.users.utility.Digester;
import org.onebusaway.users.utility.DigesterSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaltedPasswordValidationProviderV1Impl
implements KeyValidationProvider {
    public static final String PROVIDER_ID = "spv1";
    private static Logger _log = LoggerFactory.getLogger(SaltedPasswordValidationProviderV1Impl.class);
    private static final String ALGORITHM = "SHA-256";
    private static final String KEY_DELIMITER = "|";
    private Base64 _coder = new Base64();

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String generateKey(String input, String ... arguments) {
        String salt = this.generateRandomSalt(10);
        byte[] signature = Digester.digestValue(ALGORITHM, salt.getBytes(), input.getBytes());
        String encodedSig = new String(this._coder.encode(signature));
        return salt + KEY_DELIMITER + encodedSig;
    }

    @Override
    public boolean isValidKey(String key, String ... arguments) {
        if (arguments.length != 1) {
            _log.warn("expected one password argument to isValidKey call");
            return false;
        }
        String[] tokens = key.split("\\|");
        if (tokens.length != 2) {
            return false;
        }
        String salt = tokens[0];
        String encodedSig = tokens[1];
        byte[] expectedSignature = this._coder.decode(encodedSig.getBytes());
        byte[] actualSignature = Digester.digestValue(ALGORITHM, salt.getBytes(), arguments[0].getBytes());
        return Arrays.equals(actualSignature, expectedSignature);
    }

    @Override
    public void getKeyInfo(Map<String, String> info, String subKey, String ... arguments) {
        String value = DigesterSignature.getDecodedValue(subKey);
        info.put("salt", value);
    }

    private String generateRandomSalt(int digits) {
        Random r = new Random();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < digits; ++i) {
            char c = (char)(97 + r.nextInt(26));
            b.append(c);
        }
        return b.toString();
    }
}

