/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.onebusaway.container.model.IdentityBean;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.model.UserProperties;
import org.onebusaway.users.model.UserRole;

@Entity
@Table(name="oba_users")
@AccessType(value="field")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class User
extends IdentityBean<Integer> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    @AccessType(value="property")
    private Integer id;
    private Date creationTime;
    private Date lastAccessTime;
    @Column
    private boolean temporary;
    @Lob
    private UserProperties properties;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="oba_user_roles_mapping", joinColumns={@JoinColumn(name="user_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Set<UserRole> roles = new HashSet<UserRole>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user", fetch=FetchType.EAGER)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Set<UserIndex> userIndices = new HashSet<UserIndex>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public UserProperties getProperties() {
        return this.properties;
    }

    public void setProperties(UserProperties properties) {
        this.properties = properties;
    }

    public Set<UserRole> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<UserRole> roles) {
        this.roles = roles;
    }

    public Set<UserIndex> getUserIndices() {
        return this.userIndices;
    }

    public void setUserIndices(Set<UserIndex> userIndices) {
        this.userIndices = userIndices;
    }

    public String toString() {
        return "User(id=" + this.id + ")";
    }
}

