/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.util.UUID;
import org.onebusaway.users.impl.CurrentUserStrategyImpl;
import org.onebusaway.users.impl.RequestAndResponseContext;
import org.onebusaway.users.impl.authentication.DefaultUserAuthenticationToken;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.model.UserIndexKey;
import org.onebusaway.users.services.IndexedUserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;

public class AutoUserCurrentUserStrategyImpl
extends CurrentUserStrategyImpl {
    private TokenBasedRememberMeServices _rememberMeServices;
    private IndexedUserDetailsService _userDetailsService;

    @Autowired
    public void setRememberMeServices(TokenBasedRememberMeServices rememberMeServices) {
        this._rememberMeServices = rememberMeServices;
    }

    @Autowired
    public void setUserDetailsService(IndexedUserDetailsService userDetailsService) {
        this._userDetailsService = userDetailsService;
    }

    @Override
    public IndexedUserDetails getCurrentUserDetails(boolean createUserIfAppropriate) {
        IndexedUserDetails details = super.getCurrentUserDetails(createUserIfAppropriate);
        if (details == null && createUserIfAppropriate) {
            Authentication authentication = this.createAuthentication();
            details = this.getUserDetailsForAuthentication(authentication);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            RequestAndResponseContext context = RequestAndResponseContext.getContext();
            if (context != null) {
                this._rememberMeServices.onLoginSuccess(context.getRequest(), context.getResponse(), authentication);
            }
        }
        return details;
    }

    protected Authentication createAuthentication() {
        UUID uuid = UUID.randomUUID();
        UUID credentials = UUID.randomUUID();
        UserIndexKey principal = new UserIndexKey("web", uuid.toString());
        IndexedUserDetails details = this._userDetailsService.getOrCreateUserForIndexKey(principal, credentials.toString(), true);
        return new DefaultUserAuthenticationToken(details);
    }
}

