/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.util.List;
import org.onebusaway.users.client.model.UserBean;
import org.onebusaway.users.impl.CurrentUserStrategy;
import org.onebusaway.users.impl.IndexedUserDetailsImpl;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.model.User;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.model.UserIndexKey;
import org.onebusaway.users.model.properties.RouteFilter;
import org.onebusaway.users.services.CurrentUserService;
import org.onebusaway.users.services.StandardAuthoritiesService;
import org.onebusaway.users.services.UserPropertiesService;
import org.onebusaway.users.services.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CurrentUserServiceImpl
implements CurrentUserService {
    private UserService _userService;
    private UserPropertiesService _userPropertiesService;
    private StandardAuthoritiesService _authoritiesService;
    private CurrentUserStrategy _currentUserStrategy;

    @Autowired
    public void setUserService(UserService service) {
        this._userService = service;
    }

    @Autowired
    public void setUserPropertiesService(UserPropertiesService userPropertiesService) {
        this._userPropertiesService = userPropertiesService;
    }

    @Autowired
    public void setAuthoritiesService(StandardAuthoritiesService authoritiesService) {
        this._authoritiesService = authoritiesService;
    }

    @Autowired
    public void setCurrentUserStrategy(CurrentUserStrategy currentUserStrategy) {
        this._currentUserStrategy = currentUserStrategy;
    }

    @Override
    public boolean isCurrentUserAnonymous() {
        IndexedUserDetails details = this._currentUserStrategy.getCurrentUserDetails(false);
        if (details == null) {
            return true;
        }
        return details.isAnonymous();
    }

    @Override
    public boolean isCurrentUserAdmin() {
        IndexedUserDetails details = this._currentUserStrategy.getCurrentUserDetails(false);
        if (details == null) {
            return false;
        }
        return details.isAdmin();
    }

    @Override
    public boolean isCurrentUserReporting() {
        IndexedUserDetails details = this._currentUserStrategy.getCurrentUserDetails(false);
        if (details == null) {
            return false;
        }
        return details.isReporting();
    }

    @Override
    public IndexedUserDetails getCurrentUserDetails() {
        return this._currentUserStrategy.getCurrentUserDetails(false);
    }

    @Override
    public UserBean getCurrentUser() {
        return this.getCurrentUser(false);
    }

    @Override
    public UserBean getCurrentUser(boolean createUserIfAppropriate) {
        UserIndex userIndex = this._currentUserStrategy.getCurrentUserIndex(createUserIfAppropriate);
        if (userIndex == null) {
            return null;
        }
        return this._userService.getUserAsBean(userIndex.getUser());
    }

    @Override
    public UserIndex getCurrentUserAsUserIndex() {
        return this._currentUserStrategy.getCurrentUserIndex(false);
    }

    @Override
    public UserBean getAnonymousUser() {
        return this._userService.getAnonymousUser();
    }

    @Override
    public IndexedUserDetails handleUserAction(String type, String id, String credentials, boolean isAnonymous, String mode) {
        Mode m = this.getModeForRequest(mode);
        switch (m) {
            case LOGIN: {
                return this.handleLogin(type, id, credentials, isAnonymous, true);
            }
            case REGISTRATION: {
                return this.handleRegistration(type, id, credentials, isAnonymous);
            }
            case ADD_ACCOUNT: {
                return this.handleAddAccount(type, id, credentials, isAnonymous);
            }
        }
        throw new IllegalStateException("unknown mode: " + mode + " " + m);
    }

    @Override
    public IndexedUserDetails handleLogin(String type, String id, String credentials, boolean isAnonymous, boolean registerIfNewUser) {
        boolean exists;
        UserIndexKey key = new UserIndexKey(type, id);
        UserIndex index = this._userService.getUserIndexForId(key);
        boolean bl = exists = index != null;
        if (!exists) {
            if (!registerIfNewUser) {
                return null;
            }
            index = this._userService.getOrCreateUserForIndexKey(key, credentials, false);
            User newUser = index.getUser();
            User oldUser = this._currentUserStrategy.getCurrentUser(false);
            if (oldUser != null && this._userService.isAnonymous(oldUser)) {
                this._userService.mergeUsers(oldUser, newUser);
            }
        }
        return new IndexedUserDetailsImpl(this._authoritiesService, index);
    }

    @Override
    public IndexedUserDetails handleRegistration(String type, String id, String credentials, boolean isAnonymous) {
        UserIndexKey key = new UserIndexKey(type, id);
        UserIndex index = this._userService.getOrCreateUserForIndexKey(key, credentials, isAnonymous);
        User oldUser = this._currentUserStrategy.getCurrentUser(false);
        if (oldUser != null && this._userService.isAnonymous(oldUser)) {
            this._userService.mergeUsers(oldUser, index.getUser());
        }
        return new IndexedUserDetailsImpl(this._authoritiesService, index);
    }

    @Override
    public IndexedUserDetails handleAddAccount(String type, String id, String credentials, boolean isAnonymous) {
        boolean exists;
        User currentUser = this._currentUserStrategy.getCurrentUser(false);
        UserIndexKey key = new UserIndexKey(type, id);
        UserIndex index = this._userService.getUserIndexForId(key);
        boolean bl = exists = index != null;
        if (exists) {
            if (currentUser != null) {
                User existingUser = index.getUser();
                this._userService.mergeUsers(existingUser, currentUser);
            }
        } else {
            index = currentUser != null ? this._userService.addUserIndexToUser(currentUser, key, credentials) : this._userService.getOrCreateUserForIndexKey(key, credentials, isAnonymous);
        }
        return new IndexedUserDetailsImpl(this._authoritiesService, index);
    }

    @Override
    public void setDefaultLocation(String locationName, double lat, double lon) {
        User user = this._currentUserStrategy.getCurrentUser(true);
        if (user == null) {
            return;
        }
        this._userPropertiesService.setDefaultLocation(user, locationName, lat, lon);
    }

    @Override
    public void clearDefaultLocation() {
        User user = this._currentUserStrategy.getCurrentUser(false);
        if (user == null) {
            return;
        }
        this._userPropertiesService.clearDefaultLocation(user);
    }

    @Override
    public int addStopBookmark(String name, List<String> stopIds, RouteFilter filter) {
        User user = this._currentUserStrategy.getCurrentUser(true);
        if (user == null) {
            return -1;
        }
        return this._userPropertiesService.addStopBookmark(user, name, stopIds, filter);
    }

    @Override
    public void updateStopBookmark(int id, String name, List<String> stopIds, RouteFilter routeFilter) {
        User user = this._currentUserStrategy.getCurrentUser(false);
        if (user == null) {
            return;
        }
        this._userPropertiesService.updateStopBookmark(user, id, name, stopIds, routeFilter);
    }

    @Override
    public void deleteStopBookmarks(int index) {
        User user = this._currentUserStrategy.getCurrentUser(false);
        if (user == null) {
            return;
        }
        this._userPropertiesService.deleteStopBookmarks(user, index);
    }

    @Override
    public void setLastSelectedStopIds(List<String> stopIds) {
        User user = this._currentUserStrategy.getCurrentUser(true);
        if (user == null) {
            return;
        }
        this._userPropertiesService.setLastSelectedStopIds(user, stopIds);
    }

    @Override
    public void setRememberUserPreferencesEnabled(boolean rememberPreferencesEnabled) {
        User user = this._currentUserStrategy.getCurrentUser(true);
        if (user == null) {
            return;
        }
        this._userPropertiesService.setRememberUserPreferencesEnabled(user, rememberPreferencesEnabled);
    }

    @Override
    public String registerPhoneNumber(String phoneNumber) {
        User user = this._currentUserStrategy.getCurrentUser(true);
        return this._userService.registerPhoneNumber(user, phoneNumber);
    }

    @Override
    public boolean hasPhoneNumberRegistration() {
        IndexedUserDetails details = this._currentUserStrategy.getCurrentUserDetails(false);
        if (details == null) {
            return false;
        }
        return this._userService.hasPhoneNumberRegistration(details.getUserIndexKey());
    }

    @Override
    public boolean completePhoneNumberRegistration(String registrationCode) {
        UserIndex userIndex = this._currentUserStrategy.getCurrentUserIndex(false);
        if (userIndex == null) {
            return false;
        }
        if ((userIndex = this._userService.completePhoneNumberRegistration(userIndex, registrationCode)) == null) {
            return false;
        }
        this._currentUserStrategy.setCurrentUser(userIndex);
        return true;
    }

    @Override
    public void clearPhoneNumberRegistration() {
        IndexedUserDetails details = this._currentUserStrategy.getCurrentUserDetails(false);
        if (details == null) {
            return;
        }
        this._userService.clearPhoneNumberRegistration(details.getUserIndexKey());
    }

    @Override
    public void markServiceAlertAsRead(String situationId, long time, boolean isRead) {
        User user = this._currentUserStrategy.getCurrentUser(true);
        if (user == null) {
            return;
        }
        this._userPropertiesService.markServiceAlertAsRead(user, situationId, time, isRead);
    }

    @Override
    public void enableAdminRole() {
        User user = this._currentUserStrategy.getCurrentUser(true);
        if (user == null) {
            return;
        }
        this._userService.enableAdminRoleForUser(user, true);
        this._currentUserStrategy.clearCurrentUser();
    }

    @Override
    public void removeUserIndex(UserIndexKey key) {
        UserIndex index = this._currentUserStrategy.getCurrentUserIndex(false);
        if (index == null) {
            return;
        }
        boolean removingCurrentUserIndex = index.getId().equals(key);
        this._userService.removeUserIndexForUser(index.getUser(), key);
        if (removingCurrentUserIndex) {
            this._currentUserStrategy.clearCurrentUser();
        }
    }

    @Override
    public void deleteCurrentUser() {
        User user = this._currentUserStrategy.getCurrentUser(false);
        if (user == null) {
            return;
        }
        this._userService.deleteUser(user);
        this._currentUserStrategy.clearCurrentUser();
    }

    @Override
    public void resetCurrentUser() {
        User user = this._currentUserStrategy.getCurrentUser(false);
        if (user == null) {
            return;
        }
        this._userService.resetUser(user);
        this._currentUserStrategy.clearCurrentUser();
    }

    private Mode getModeForRequest(String mode) {
        if (mode == null) {
            return Mode.LOGIN;
        }
        if (mode.equals("registration")) {
            return Mode.REGISTRATION;
        }
        if (mode.equals("add-account")) {
            return Mode.ADD_ACCOUNT;
        }
        return Mode.LOGIN;
    }

    private static enum Mode {
        LOGIN,
        REGISTRATION,
        ADD_ACCOUNT;

    }
}

