/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import org.onebusaway.users.impl.CurrentUserStrategy;
import org.onebusaway.users.impl.IndexedUserDetailsImpl;
import org.onebusaway.users.impl.authentication.DefaultUserAuthenticationToken;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.model.User;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.services.StandardAuthoritiesService;
import org.onebusaway.users.services.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class CurrentUserStrategyImpl
implements CurrentUserStrategy {
    private UserService _userService;
    private StandardAuthoritiesService _authoritiesService;

    @Autowired
    public void setUserService(UserService userService) {
        this._userService = userService;
    }

    @Autowired
    public void setAuthoritiesService(StandardAuthoritiesService authoritiesService) {
        this._authoritiesService = authoritiesService;
    }

    @Override
    public User getCurrentUser(boolean createUserIfAppropriate) {
        UserIndex userIndex = this.getCurrentUserIndex(createUserIfAppropriate);
        if (userIndex == null) {
            return null;
        }
        return userIndex.getUser();
    }

    @Override
    public UserIndex getCurrentUserIndex(boolean createUserIfAppropriate) {
        IndexedUserDetails details = this.getCurrentUserDetails(createUserIfAppropriate);
        if (details == null) {
            return null;
        }
        return this._userService.getUserIndexForId(details.getUserIndexKey());
    }

    @Override
    public IndexedUserDetails getCurrentUserDetails(boolean createUserIfAppropriate) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        return this.getUserDetailsForAuthentication(authentication);
    }

    @Override
    public void setCurrentUser(UserIndex userIndex) {
        IndexedUserDetailsImpl userDetails = new IndexedUserDetailsImpl(this._authoritiesService, userIndex);
        DefaultUserAuthenticationToken token = new DefaultUserAuthenticationToken(userDetails);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
    }

    @Override
    public void clearCurrentUser() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    protected IndexedUserDetails getUserDetailsForAuthentication(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        if (principal instanceof IndexedUserDetails) {
            return (IndexedUserDetails)principal;
        }
        Object details = authentication.getDetails();
        if (details instanceof IndexedUserDetails) {
            return (IndexedUserDetails)details;
        }
        return null;
    }
}

