/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.model.UserIndexKey;
import org.onebusaway.users.model.UserRole;
import org.onebusaway.users.services.StandardAuthoritiesService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class IndexedUserDetailsImpl
extends User
implements IndexedUserDetails {
    private static final long serialVersionUID = 2L;
    private UserIndexKey _userIndexKey;

    public IndexedUserDetailsImpl(StandardAuthoritiesService authoritiesService, UserIndex userIndex) {
        super(userIndex.getId().toString(), userIndex.getCredentials(), true, true, true, true, IndexedUserDetailsImpl.getGrantedAuthoritiesForUser(authoritiesService, userIndex.getUser()));
        this._userIndexKey = userIndex.getId();
    }

    @Override
    public UserIndexKey getUserIndexKey() {
        return this._userIndexKey;
    }

    @Override
    public boolean isAnonymous() {
        return this.hasAuthority("ROLE_ANONYMOUS");
    }

    @Override
    public boolean isAdmin() {
        return this.hasAuthority("ROLE_ADMINISTRATOR");
    }

    @Override
    public boolean isReporting() {
        return this.hasAuthority("ROLE_REPORTING");
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._userIndexKey == null ? 0 : this._userIndexKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexedUserDetailsImpl other = (IndexedUserDetailsImpl)obj;
        return !(this._userIndexKey == null ? other._userIndexKey != null : !this._userIndexKey.equals(other._userIndexKey));
    }

    private boolean hasAuthority(String authorityToCheck) {
        Collection authorities = this.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            if (!authority.getAuthority().equals(authorityToCheck)) continue;
            return true;
        }
        return false;
    }

    private static Collection<? extends GrantedAuthority> getGrantedAuthoritiesForUser(StandardAuthoritiesService authoritiesService, org.onebusaway.users.model.User user) {
        Set<UserRole> roles = user.getRoles();
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(roles.size());
        int index = 0;
        for (UserRole role : roles) {
            authorities.add(index++, authoritiesService.getNameBasedAuthority(role.getName()));
        }
        return authorities;
    }
}

