/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.onebusaway.users.model.User;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.model.UserIndexKey;
import org.onebusaway.users.model.UserRole;
import org.onebusaway.users.services.UserDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class UserDaoImpl
implements UserDao {
    private SessionFactory _sessionFactory;

    UserDaoImpl() {
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    @Override
    @Transactional
    public int getNumberOfUsers() {
        Query query = this.getSession().getNamedQuery("numberOfUsers");
        List values = query.list();
        if (values == null || values.size() == 0) {
            return 0;
        }
        Number v = (Number)values.get(0);
        return v.intValue();
    }

    @Override
    @Transactional
    public List<Integer> getAllUserIds() {
        return this.getSession().createQuery("SELECT user.id FROM User user").list();
    }

    @Override
    @Transactional
    public List<Integer> getAllUserIdsInRange(int firstResult, int maxResults) {
        Query query = this.getSession().createQuery("SELECT user.id FROM User user");
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    @Transactional
    public long getNumberOfStaleUsers(Date lastAccessTime) {
        List values = this.getSession().getNamedQuery("numberOfStaleUsers").setTimestamp("lastAccessTime", lastAccessTime).list();
        if (values == null || values.size() == 0) {
            return 0L;
        }
        Number v = (Number)values.get(0);
        return v.intValue();
    }

    @Override
    @Transactional
    public List<Integer> getStaleUserIdsInRange(Date lastAccessTime, int firstResult, int maxResults) {
        Query query = this.getSession().createQuery("SELECT user.id FROM User user WHERE lastAccessTime < :lastAccessTime");
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        query.setTimestamp("lastAccessTime", lastAccessTime);
        return query.list();
    }

    @Override
    @Transactional
    public User getUserForId(int id) {
        return (User)((Object)this.getSession().get(User.class, (Serializable)Integer.valueOf(id)));
    }

    @Override
    @Transactional
    public void saveOrUpdateUser(User user) {
        this.getSession().saveOrUpdate((Object)user);
    }

    @Override
    public void saveOrUpdateUsers(User ... users) {
        Session session = this.getSession();
        ArrayList list = new ArrayList(users.length);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            session.saveOrUpdate(it.next());
        }
    }

    @Override
    @Transactional
    public void deleteUser(User user) {
        this.getSession().delete((Object)user);
    }

    @Override
    @Transactional
    public int getNumberOfUserRoles() {
        List values = this.getSession().getNamedQuery("numberOfUserRoles").list();
        if (values == null || values.size() == 0) {
            return 0;
        }
        Number v = (Number)values.get(0);
        return v.intValue();
    }

    @Override
    @Transactional
    public int getNumberOfUsersWithRole(UserRole role) {
        Query query = this.getSession().getNamedQuery("numberOfUsersWithRole");
        query.setParameter("role", (Object)role);
        List values = query.list();
        if (values == null || values.size() == 0) {
            return 0;
        }
        Number v = (Number)values.get(0);
        return v.intValue();
    }

    @Override
    @Transactional
    public UserRole getUserRoleForName(String name) {
        return (UserRole)this.getSession().get(UserRole.class, (Serializable)((Object)name));
    }

    @Override
    @Transactional
    public void saveOrUpdateUserRole(UserRole userRole) {
        this.getSession().saveOrUpdate((Object)userRole);
    }

    @Override
    @Transactional
    public List<String> getUserIndexKeyValuesForKeyType(String keyType) {
        return this.getSession().getNamedQuery("userIndexKeyValuesForKeyType").setString("type", keyType).list();
    }

    @Override
    @Transactional
    public Integer getUserKeyCount(String keyType) {
        Criteria criteria = this.getSession().createCriteria(User.class).createCriteria("userIndices").add((Criterion)Restrictions.eq((String)"id.type", (Object)keyType)).setProjection(Projections.rowCount());
        List users = criteria.list();
        Long lcount = (Long)criteria.uniqueResult();
        Integer count = BigDecimal.valueOf(lcount).intValueExact();
        return count;
    }

    @Override
    @Transactional
    public List<User> getUsersForKeyType(int start, int maxResults, String keyType) {
        Criteria criteria = this.getSession().createCriteria(User.class).createCriteria("userIndices").add((Criterion)Restrictions.eq((String)"id.type", (Object)keyType)).setFirstResult(start).setMaxResults(maxResults);
        List users = criteria.list();
        return users;
    }

    @Override
    @Transactional
    public UserIndex getUserIndexForId(UserIndexKey key) {
        return (UserIndex)this.getSession().get(UserIndex.class, (Serializable)key);
    }

    @Override
    public void saveOrUpdateUserIndex(UserIndex userIndex) {
        this.getSession().saveOrUpdate((Object)userIndex);
    }

    @Override
    @Transactional
    public void deleteUserIndex(UserIndex index) {
        this.getSession().delete((Object)index);
    }

    private Session getSession() {
        return this._sessionFactory.getCurrentSession();
    }
}

