/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.onebusaway.users.model.User;
import org.onebusaway.users.model.UserProperties;
import org.onebusaway.users.services.UserDao;
import org.onebusaway.users.services.UserPropertiesMigration;
import org.onebusaway.users.services.UserPropertiesMigrationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPropertiesMigrationBulkOperation<T extends UserProperties> {
    private static final int FETCH_LIMIT = 100;
    private static Logger _log = LoggerFactory.getLogger(UserPropertiesMigrationBulkOperation.class);
    private ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();
    private UserPropertiesMigration _propertiesMigration;
    private Class<T> _target;
    private UserDao _dao;
    private int _numberOfUsers;
    private AtomicInteger _numberOfUsersProcessed = new AtomicInteger();
    private AtomicInteger _numberOfUsersConverted = new AtomicInteger();
    private boolean _canceled = false;

    public static <T extends UserProperties> UserPropertiesMigrationBulkOperation<T> execute(UserDao dao, UserPropertiesMigration propertiesMigration, Class<T> target) {
        UserPropertiesMigrationBulkOperation<T> op = new UserPropertiesMigrationBulkOperation<T>(dao, propertiesMigration, target);
        op.run();
        return op;
    }

    private UserPropertiesMigrationBulkOperation(UserDao dao, UserPropertiesMigration propertiesMigration, Class<T> target) {
        this._dao = dao;
        this._propertiesMigration = propertiesMigration;
        this._target = target;
    }

    public void run() {
        this._numberOfUsers = this._dao.getNumberOfUsers();
        for (int i = 0; i < this._numberOfUsers; i += 100) {
            this._executor.submit(new Go(i));
        }
    }

    public synchronized void cancel() {
        this._canceled = true;
        this._executor.shutdownNow();
    }

    public UserPropertiesMigrationStatus getStatus() {
        UserPropertiesMigrationStatus status = new UserPropertiesMigrationStatus();
        status.setCanceled(this.isCanceled());
        status.setComplete(this.isComplete());
        status.setNumberOfUsers(this.getNumberOfUsers());
        status.setNumberOfUsersConverted(this.getNumberOfUsersConverted());
        status.setNumberOfUsersProcessed(this.getNumberOfUsersProcessed());
        return status;
    }

    public int getNumberOfUsers() {
        return this._numberOfUsers;
    }

    public int getNumberOfUsersConverted() {
        return this._numberOfUsersConverted.get();
    }

    public int getNumberOfUsersProcessed() {
        return this._numberOfUsersProcessed.get();
    }

    public synchronized boolean isCanceled() {
        return this._canceled;
    }

    public boolean isComplete() {
        return this.getNumberOfUsers() <= this.getNumberOfUsersProcessed();
    }

    private void updateStatistics(int usersProcessed, int usersConverted) {
        this._numberOfUsersProcessed.addAndGet(usersProcessed);
        this._numberOfUsersConverted.addAndGet(usersConverted);
    }

    private class Go
    implements Runnable {
        private int _offset;

        public Go(int offset) {
            this._offset = offset;
        }

        @Override
        public void run() {
            _log.info("offset=" + this._offset);
            int usersProcessed = 0;
            int usersConverted = 0;
            try {
                List<Integer> userIds = UserPropertiesMigrationBulkOperation.this._dao.getAllUserIdsInRange(this._offset, 100);
                for (int userId : userIds) {
                    User user = UserPropertiesMigrationBulkOperation.this._dao.getUserForId(userId);
                    _log.info("processing user: id=" + user.getId());
                    if (UserPropertiesMigrationBulkOperation.this._propertiesMigration.needsMigration(user.getProperties(), UserPropertiesMigrationBulkOperation.this._target)) {
                        _log.info("migrating user: id=" + user.getId());
                        Object properties = UserPropertiesMigrationBulkOperation.this._propertiesMigration.migrate(user.getProperties(), UserPropertiesMigrationBulkOperation.this._target);
                        user.setProperties((UserProperties)properties);
                        UserPropertiesMigrationBulkOperation.this._dao.saveOrUpdateUser(user);
                        ++usersConverted;
                    }
                    ++usersProcessed;
                }
            }
            catch (Throwable ex) {
                _log.warn("error processing users for verion migration", ex);
                usersProcessed = Math.min(100, UserPropertiesMigrationBulkOperation.this._numberOfUsers - this._offset);
            }
            UserPropertiesMigrationBulkOperation.this.updateStatistics(usersProcessed, usersConverted);
        }
    }
}

