/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.util.Arrays;
import javax.annotation.PreDestroy;
import org.onebusaway.users.impl.UserPropertiesMigrationBulkOperation;
import org.onebusaway.users.model.UserProperties;
import org.onebusaway.users.model.UserPropertiesV1;
import org.onebusaway.users.model.properties.Bookmark;
import org.onebusaway.users.model.properties.RouteFilter;
import org.onebusaway.users.model.properties.UserPropertiesV2;
import org.onebusaway.users.model.properties.UserPropertiesV3;
import org.onebusaway.users.model.properties.UserPropertiesV4;
import org.onebusaway.users.services.UserDao;
import org.onebusaway.users.services.UserPropertiesMigration;
import org.onebusaway.users.services.UserPropertiesMigrationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserPropertiesMigrationImpl
implements UserPropertiesMigration {
    private static Logger _log = LoggerFactory.getLogger(UserPropertiesMigrationImpl.class);
    private Object _userPropertiesMigrationOperationLock = new Object();
    private UserPropertiesMigrationBulkOperation<?> _operation = null;
    private UserDao _userDao;

    @Autowired
    public void setUserDao(UserDao userDao) {
        this._userDao = userDao;
    }

    @PreDestroy
    public void stop() {
        if (this._operation != null) {
            this._operation.cancel();
        }
        this._operation = null;
    }

    @Override
    public boolean needsMigration(UserProperties properties, Class<?> target) {
        return !target.isAssignableFrom(properties.getClass());
    }

    @Override
    public <T extends UserProperties> T migrate(UserProperties properties, Class<T> target) {
        if (target.isAssignableFrom(properties.getClass())) {
            return (T)properties;
        }
        if (UserPropertiesV1.class.isAssignableFrom(properties.getClass())) {
            if (target == UserPropertiesV2.class) {
                return (T)this.getV2Properties((UserPropertiesV1)properties);
            }
            if (target == UserPropertiesV3.class) {
                properties = this.getV2Properties((UserPropertiesV1)properties);
                return (T)this.getV3Properties((UserPropertiesV2)properties);
            }
            if (target == UserPropertiesV4.class) {
                properties = this.getV2Properties((UserPropertiesV1)properties);
                properties = this.getV3Properties((UserPropertiesV2)properties);
                return (T)this.getV4Properties((UserPropertiesV3)properties);
            }
        }
        if (UserPropertiesV2.class.isAssignableFrom(properties.getClass())) {
            if (target == UserPropertiesV1.class) {
                return (T)this.getV1Properties((UserPropertiesV2)properties);
            }
            if (target == UserPropertiesV3.class) {
                return (T)this.getV3Properties((UserPropertiesV2)properties);
            }
            if (target == UserPropertiesV4.class) {
                properties = this.getV3Properties((UserPropertiesV2)properties);
                return (T)this.getV4Properties((UserPropertiesV3)properties);
            }
        }
        if (UserPropertiesV3.class.isAssignableFrom(properties.getClass())) {
            if (target == UserPropertiesV1.class) {
                properties = this.getV2PropertiesFromV3((UserPropertiesV3)properties);
                return (T)this.getV1Properties((UserPropertiesV2)properties);
            }
            if (target == UserPropertiesV2.class) {
                return (T)this.getV2PropertiesFromV3((UserPropertiesV3)properties);
            }
            if (target == UserPropertiesV4.class) {
                return (T)this.getV4Properties((UserPropertiesV3)properties);
            }
        }
        if (UserPropertiesV4.class.isAssignableFrom(properties.getClass())) {
            if (target == UserPropertiesV1.class) {
                properties = this.getV3PropertiesFromV4((UserPropertiesV4)properties);
                properties = this.getV2PropertiesFromV3((UserPropertiesV3)properties);
                return (T)this.getV1Properties((UserPropertiesV2)properties);
            }
            if (target == UserPropertiesV2.class) {
                properties = this.getV3PropertiesFromV4((UserPropertiesV4)properties);
                return (T)this.getV2PropertiesFromV3((UserPropertiesV3)properties);
            }
            if (target == UserPropertiesV3.class) {
                return (T)this.getV3PropertiesFromV4((UserPropertiesV4)properties);
            }
        }
        throw new IllegalStateException("can't convert properties: from=" + properties.getClass() + " to=" + target);
    }

    @Override
    public <T extends UserProperties> void startUserPropertiesBulkMigration(Class<T> target) {
        if (this._operation == null || this._operation.isCanceled() || this._operation.isComplete()) {
            if (this._operation != null) {
                this._operation.cancel();
            }
            this._operation = UserPropertiesMigrationBulkOperation.execute(this._userDao, this, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserPropertiesMigrationStatus getUserPropertiesBulkMigrationStatus() {
        Object object = this._userPropertiesMigrationOperationLock;
        synchronized (object) {
            if (this._operation != null) {
                return this._operation.getStatus();
            }
            return null;
        }
    }

    private UserPropertiesV4 getV4Properties(UserPropertiesV3 v3) {
        UserPropertiesV4 v4 = new UserPropertiesV4();
        v4.setRememberPreferencesEnabled(v3.isRememberPreferencesEnabled());
        v4.setDefaultLocationLat(v3.getDefaultLocationLat());
        v4.setDefaultLocationLon(v3.getDefaultLocationLon());
        v4.setDefaultLocationName(v3.getDefaultLocationName());
        v4.setBookmarks(v3.getBookmarks());
        v4.setMinApiRequestInterval(v3.getMinApiRequestInterval());
        v4.setReadSituationIdsWithReadTime(v3.getReadSituationIdsWithReadTime());
        v4.setContactCompany(v3.getContactCompany());
        v4.setContactDetails(v3.getContactDetails());
        v4.setContactName(v3.getContactName());
        v4.setContactEmail(v3.getContactEmail());
        return v4;
    }

    private UserPropertiesV3 getV3PropertiesFromV4(UserPropertiesV4 v4) {
        UserPropertiesV3 v3 = new UserPropertiesV3();
        v3.setRememberPreferencesEnabled(v4.isRememberPreferencesEnabled());
        v3.setDefaultLocationLat(v4.getDefaultLocationLat());
        v3.setDefaultLocationLon(v4.getDefaultLocationLon());
        v3.setDefaultLocationName(v4.getDefaultLocationName());
        v3.setBookmarks(v4.getBookmarks());
        v3.setMinApiRequestInterval(v4.getMinApiRequestInterval());
        v3.setReadSituationIdsWithReadTime(v4.getReadSituationIdsWithReadTime());
        return v3;
    }

    private UserPropertiesV3 getV3Properties(UserPropertiesV2 v2) {
        UserPropertiesV3 v3 = new UserPropertiesV3();
        v3.setRememberPreferencesEnabled(v2.isRememberPreferencesEnabled());
        v3.setDefaultLocationLat(v2.getDefaultLocationLat());
        v3.setDefaultLocationLon(v2.getDefaultLocationLon());
        v3.setDefaultLocationName(v2.getDefaultLocationName());
        v3.setBookmarks(v2.getBookmarks());
        v3.setMinApiRequestInterval(v2.getMinApiRequestInterval());
        v3.setReadSituationIdsWithReadTime(v2.getReadSituationIdsWithReadTime());
        return v3;
    }

    private UserPropertiesV2 getV2PropertiesFromV3(UserPropertiesV3 v3) {
        UserPropertiesV2 v2 = new UserPropertiesV2();
        v2.setRememberPreferencesEnabled(v3.isRememberPreferencesEnabled());
        v2.setDefaultLocationLat(v3.getDefaultLocationLat());
        v2.setDefaultLocationLon(v3.getDefaultLocationLon());
        v2.setDefaultLocationName(v3.getDefaultLocationName());
        v2.setBookmarks(v3.getBookmarks());
        v2.setMinApiRequestInterval(v3.getMinApiRequestInterval());
        v2.setReadSituationIdsWithReadTime(v3.getReadSituationIdsWithReadTime());
        return v2;
    }

    private UserPropertiesV2 getV2Properties(UserPropertiesV1 v1) {
        UserPropertiesV2 v2 = new UserPropertiesV2();
        v2.setRememberPreferencesEnabled(v1.isRememberPreferencesEnabled());
        v2.setDefaultLocationLat(v1.getDefaultLocationLat());
        v2.setDefaultLocationLon(v1.getDefaultLocationLon());
        v2.setDefaultLocationName(v1.getDefaultLocationName());
        int index = 0;
        for (String stopId : v1.getBookmarkedStopIds()) {
            Bookmark bookmark = new Bookmark(index++, null, Arrays.asList(stopId), new RouteFilter());
            v2.getBookmarks().add(bookmark);
        }
        return v2;
    }

    private UserPropertiesV1 getV1Properties(UserPropertiesV2 v2) {
        UserPropertiesV1 v1 = new UserPropertiesV1();
        v1.setRememberPreferencesEnabled(v2.isRememberPreferencesEnabled());
        v1.setDefaultLocationLat(v2.getDefaultLocationLat());
        v1.setDefaultLocationLon(v2.getDefaultLocationLon());
        v1.setDefaultLocationName(v2.getDefaultLocationName());
        for (Bookmark bookmark : v2.getBookmarks()) {
            v1.getBookmarkedStopIds().addAll(bookmark.getStopIds());
        }
        return v1;
    }
}

