/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.container.cache.CacheableArgument;
import org.onebusaway.users.client.model.UserBean;
import org.onebusaway.users.client.model.UserIndexBean;
import org.onebusaway.users.impl.PhoneNumberLibrary;
import org.onebusaway.users.impl.authentication.VersionedPasswordEncoder;
import org.onebusaway.users.model.User;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.model.UserIndexKey;
import org.onebusaway.users.model.UserRole;
import org.onebusaway.users.model.properties.UserPropertiesV4;
import org.onebusaway.users.services.StandardAuthoritiesService;
import org.onebusaway.users.services.UserDao;
import org.onebusaway.users.services.UserPropertiesMigration;
import org.onebusaway.users.services.UserPropertiesMigrationStatus;
import org.onebusaway.users.services.UserPropertiesService;
import org.onebusaway.users.services.UserService;
import org.onebusaway.users.services.internal.UserIndexRegistrationService;
import org.onebusaway.users.services.internal.UserRegistration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserServiceImpl
implements UserService {
    private UserDao _userDao;
    private StandardAuthoritiesService _authoritiesService;
    private UserPropertiesMigration _userPropertiesMigration;
    private UserPropertiesService _userPropertiesService;
    private UserIndexRegistrationService _userIndexRegistrationService;
    private VersionedPasswordEncoder _passwordEncoder;
    private ExecutorService _executors;
    private Object _deleteStaleUsersLock = new Object();
    private Future<?> _deleteStaleUsersTask;

    @Autowired
    public void setUserDao(UserDao dao) {
        this._userDao = dao;
    }

    @Autowired
    public void setAuthoritiesService(StandardAuthoritiesService authoritiesService) {
        this._authoritiesService = authoritiesService;
    }

    @Autowired
    public void setUserPropertiesService(UserPropertiesService userPropertiesService) {
        this._userPropertiesService = userPropertiesService;
    }

    @Autowired
    public void setUserIndexRegistrationService(UserIndexRegistrationService userIndexRegistrationService) {
        this._userIndexRegistrationService = userIndexRegistrationService;
    }

    @Autowired
    @Qualifier(value="passwordEncoderV1")
    public void setPasswordEncoder(VersionedPasswordEncoder passwordEncoder) {
        this._passwordEncoder = passwordEncoder;
    }

    @PostConstruct
    public void start() {
        this._executors = Executors.newSingleThreadExecutor();
    }

    @PreDestroy
    public void stop() {
        this._executors.shutdownNow();
    }

    @Override
    @Transactional(readOnly=true)
    public int getNumberOfUsers() {
        return this._userDao.getNumberOfUsers();
    }

    @Override
    @Transactional
    public List<Integer> getAllUserIds() {
        return this._userDao.getAllUserIds();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Integer> getAllUserIdsInRange(int offset, int limit) {
        return this._userDao.getAllUserIdsInRange(offset, limit);
    }

    @Override
    @Transactional(readOnly=true)
    public int getNumberOfAdmins() {
        UserRole admin = this._authoritiesService.getAdministratorRole();
        return this._userDao.getNumberOfUsersWithRole(admin);
    }

    @Override
    @Transactional(readOnly=true)
    public User getUserForId(int userId) {
        return this._userDao.getUserForId(userId);
    }

    @Override
    public UserBean getUserAsBean(User user) {
        UserBean bean = new UserBean();
        bean.setUserId(Integer.toString(user.getId()));
        UserRole anonymous = this._authoritiesService.getAnonymousRole();
        boolean isAnonymous = user.getRoles().contains(anonymous);
        bean.setAnonymous(isAnonymous);
        UserRole admin = this._authoritiesService.getAdministratorRole();
        boolean isAdmin = user.getRoles().contains(admin);
        bean.setAdmin(isAdmin);
        ArrayList<UserIndexBean> indices = new ArrayList<UserIndexBean>();
        bean.setIndices(indices);
        for (UserIndex index : user.getUserIndices()) {
            UserIndexKey key = index.getId();
            UserIndexBean indexBean = new UserIndexBean();
            indexBean.setType(key.getType());
            indexBean.setValue(key.getValue());
            indices.add(indexBean);
        }
        this._userPropertiesService.getUserAsBean(user, bean);
        return bean;
    }

    @Override
    public UserBean getAnonymousUser() {
        UserBean bean = new UserBean();
        bean.setUserId("-1");
        bean.setAnonymous(true);
        bean.setAdmin(false);
        this._userPropertiesService.getAnonymousUserAsBean(bean);
        return bean;
    }

    @Override
    public void resetUser(User user) {
        this._userPropertiesService.resetUser(user);
    }

    @Override
    @Transactional
    public void deleteUser(User user) {
        this._userDao.deleteUser(user);
    }

    @Override
    public boolean isAnonymous(User user) {
        return user.getRoles().contains(this._authoritiesService.getAnonymousRole());
    }

    @Override
    public boolean isAdministrator(User user) {
        return user.getRoles().contains(this._authoritiesService.getAdministratorRole());
    }

    @Override
    @Transactional
    public void enableAdminRoleForUser(User user, boolean onlyIfNoOtherAdmins) {
        int count;
        UserRole adminRole = this._authoritiesService.getUserRoleForName("ROLE_ADMINISTRATOR");
        if (onlyIfNoOtherAdmins && (count = this._userDao.getNumberOfUsersWithRole(adminRole)) > 0) {
            return;
        }
        Set<UserRole> roles = user.getRoles();
        if (roles.add(adminRole)) {
            this._userDao.saveOrUpdateUser(user);
        }
    }

    @Override
    @Transactional
    public void disableAdminRoleForUser(User user, boolean onlyIfOtherAdmins) {
        int count;
        UserRole adminRole = this._authoritiesService.getUserRoleForName("ROLE_ADMINISTRATOR");
        if (onlyIfOtherAdmins && (count = this._userDao.getNumberOfUsersWithRole(adminRole)) < 2) {
            return;
        }
        Set<UserRole> roles = user.getRoles();
        if (roles.remove(adminRole)) {
            this._userDao.saveOrUpdateUser(user);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getUserIndexKeyValuesForKeyType(String keyType) {
        return this._userDao.getUserIndexKeyValuesForKeyType(keyType);
    }

    @Override
    @Transactional(readOnly=true)
    public Integer getApiKeyCount() {
        return this._userDao.getUserKeyCount("api");
    }

    @Override
    @Transactional(readOnly=true)
    public List<User> getApiKeys(int start, int maxResults) {
        return this._userDao.getUsersForKeyType(start, maxResults, "api");
    }

    @Override
    @Transactional
    public UserIndex getOrCreateUserForIndexKey(UserIndexKey key, String credentials, boolean isAnonymous) {
        UserIndex userIndex = this._userDao.getUserIndexForId(key);
        if (userIndex == null) {
            User user = new User();
            user.setCreationTime(new Date());
            user.setTemporary(true);
            user.setProperties(new UserPropertiesV4());
            HashSet<UserRole> roles = new HashSet<UserRole>();
            if (isAnonymous) {
                roles.add(this._authoritiesService.getAnonymousRole());
            } else {
                roles.add(this._authoritiesService.getUserRole());
            }
            user.setRoles(roles);
            userIndex = new UserIndex();
            userIndex.setId(key);
            userIndex.setCredentials(credentials);
            userIndex.setUser(user);
            user.getUserIndices().add(userIndex);
            this._userDao.saveOrUpdateUser(user);
        }
        return userIndex;
    }

    @Override
    @Transactional
    public UserIndex getOrCreateUserForUsernameAndPassword(String username, String password) {
        String credentials = this._passwordEncoder.encodePassword(password, username);
        UserIndexKey key = new UserIndexKey("username", username);
        return this.getOrCreateUserForIndexKey(key, credentials, false);
    }

    @Override
    @Transactional(readOnly=true)
    public UserIndex getUserIndexForId(UserIndexKey key) {
        return this._userDao.getUserIndexForId(key);
    }

    @Override
    public UserIndex getUserIndexForUsername(String username) throws UsernameNotFoundException {
        String value;
        int index = username.indexOf(95);
        if (index == -1) {
            throw new UsernameNotFoundException("username did not take the form type_value: " + username);
        }
        String type = username.substring(0, index);
        UserIndexKey key = new UserIndexKey(type, value = username.substring(index + 1));
        UserIndex userIndex = this.getUserIndexForId(key);
        if (userIndex == null) {
            throw new UsernameNotFoundException(key.toString());
        }
        return userIndex;
    }

    @Override
    @Transactional
    public UserIndex addUserIndexToUser(User user, UserIndexKey key, String credentials) {
        UserIndex index = new UserIndex();
        index.setId(key);
        index.setCredentials(credentials);
        index.setUser(user);
        user.getUserIndices().add(index);
        this._userDao.saveOrUpdateUser(user);
        return index;
    }

    @Override
    @Transactional
    public void removeUserIndexForUser(User user, UserIndexKey key) {
        for (UserIndex index : user.getUserIndices()) {
            if (!index.getId().equals(key)) continue;
            this._userDao.deleteUserIndex(index);
            index.setUser(null);
            user.getUserIndices().remove(index);
            this._userDao.saveOrUpdateUser(user);
            return;
        }
    }

    @Override
    @Transactional
    public void setCredentialsForUserIndex(UserIndex userIndex, String credentials) {
        userIndex.setCredentials(credentials);
        this._userDao.saveOrUpdateUserIndex(userIndex);
    }

    @Override
    @Transactional
    public void setPasswordForUsernameUserIndex(UserIndex userIndex, String password) {
        UserIndexKey id = userIndex.getId();
        if (!"username".equals(id.getType())) {
            throw new IllegalArgumentException("expected UserIndex of type username");
        }
        String credentials = this._passwordEncoder.encodePassword(password, id.getValue());
        this.setCredentialsForUserIndex(userIndex, credentials);
    }

    @Override
    @Transactional
    public void mergeUsers(User sourceUser, User targetUser) {
        if (sourceUser.equals((Object)targetUser)) {
            return;
        }
        if (sourceUser.getCreationTime().before(targetUser.getCreationTime())) {
            targetUser.setCreationTime(sourceUser.getCreationTime());
        }
        this._userPropertiesService.mergeProperties(sourceUser, targetUser);
        this.mergeRoles(sourceUser, targetUser);
        ArrayList<UserIndex> indices = new ArrayList<UserIndex>(sourceUser.getUserIndices());
        for (UserIndex index : indices) {
            index.setUser(targetUser);
            targetUser.getUserIndices().add(index);
        }
        sourceUser.getUserIndices().clear();
        this._userDao.saveOrUpdateUsers(sourceUser, targetUser);
        this.deleteUser(sourceUser);
    }

    @Override
    public String registerPhoneNumber(User user, String phoneNumber) {
        int code = (int)(Math.random() * 8999.0 + 1000.0);
        String codeAsString = Integer.toString(code);
        phoneNumber = PhoneNumberLibrary.normalizePhoneNumber(phoneNumber);
        UserIndexKey key = new UserIndexKey("phoneNumber", phoneNumber);
        this._userIndexRegistrationService.setRegistrationForUserIndexKey(key, user.getId(), codeAsString);
        return codeAsString;
    }

    @Override
    public boolean hasPhoneNumberRegistration(UserIndexKey userIndexKey) {
        return this._userIndexRegistrationService.hasRegistrationForUserIndexKey(userIndexKey);
    }

    @Override
    @Transactional
    public UserIndex completePhoneNumberRegistration(UserIndex userIndex, String registrationCode) {
        UserRegistration registration = this._userIndexRegistrationService.getRegistrationForUserIndexKey(userIndex.getId());
        if (registration == null) {
            return null;
        }
        String expectedCode = registration.getRegistrationCode();
        if (!expectedCode.equals(registrationCode)) {
            return null;
        }
        this._userIndexRegistrationService.clearRegistrationForUserIndexKey(userIndex.getId());
        User targetUser = this._userDao.getUserForId(registration.getUserId());
        if (targetUser == null) {
            return null;
        }
        User phoneUser = userIndex.getUser();
        if (phoneUser.equals((Object)targetUser)) {
            return userIndex;
        }
        if (phoneUser.getUserIndices().size() == 1) {
            this.mergeUsers(userIndex.getUser(), targetUser);
        } else {
            userIndex.setUser(targetUser);
            targetUser.getUserIndices().add(userIndex);
            phoneUser.getUserIndices().remove(userIndex);
            this._userDao.saveOrUpdateUsers(phoneUser, targetUser);
        }
        return this.getUserIndexForId(userIndex.getId());
    }

    @Override
    public void clearPhoneNumberRegistration(UserIndexKey userIndexKey) {
        this._userIndexRegistrationService.clearRegistrationForUserIndexKey(userIndexKey);
    }

    @Override
    public void startUserPropertiesMigration() {
        this._userPropertiesMigration.startUserPropertiesBulkMigration(this._userPropertiesService.getUserPropertiesType());
    }

    @Override
    public UserPropertiesMigrationStatus getUserPropertiesMigrationStatus() {
        return this._userPropertiesMigration.getUserPropertiesBulkMigrationStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStaleUsers() {
        Object object = this._deleteStaleUsersLock;
        synchronized (object) {
            if (this._deleteStaleUsersTask != null && !this._deleteStaleUsersTask.isDone()) {
                return;
            }
            Calendar c = Calendar.getInstance();
            c.add(2, -1);
            Date lastAccessTime = c.getTime();
            this._deleteStaleUsersTask = this._executors.submit(new DeleteStaleUsersTask(lastAccessTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeletingStaleUsers() {
        Object object = this._deleteStaleUsersLock;
        synchronized (object) {
            return this._deleteStaleUsersTask != null && !this._deleteStaleUsersTask.isDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDeleteStaleUsers() {
        Object object = this._deleteStaleUsersLock;
        synchronized (object) {
            if (this._deleteStaleUsersTask != null && !this._deleteStaleUsersTask.isDone()) {
                this._deleteStaleUsersTask.cancel(true);
                this._deleteStaleUsersTask = null;
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public long getNumberOfStaleUsers() {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        Date lastAccessTime = c.getTime();
        return this._userDao.getNumberOfStaleUsers(lastAccessTime);
    }

    private void mergeRoles(User sourceUser, User targetUser) {
        HashSet<UserRole> roles = new HashSet<UserRole>();
        roles.addAll(sourceUser.getRoles());
        roles.addAll(targetUser.getRoles());
        UserRole anon = this._authoritiesService.getAnonymousRole();
        UserRole user = this._authoritiesService.getUserRole();
        if (roles.contains(user)) {
            roles.remove(anon);
        }
        targetUser.setRoles(roles);
    }

    @Override
    @Cacheable
    @Transactional
    public Long getMinApiRequestIntervalForKey(String key, @CacheableArgument(cacheRefreshIndicator=true) boolean forceRefresh) {
        UserIndexKey indexKey = new UserIndexKey("api", key);
        UserIndex userIndex = this.getUserIndexForId(indexKey);
        if (userIndex == null) {
            return null;
        }
        User user = userIndex.getUser();
        UserBean bean = this.getUserAsBean(user);
        return bean.getMinApiRequestInterval();
    }

    @Transactional
    public void deleteStaleUsers(Date lastAccessTime) {
        List<Integer> userIds;
        block0: while (!(userIds = this._userDao.getStaleUserIdsInRange(lastAccessTime, 0, 100)).isEmpty()) {
            Iterator<Integer> iterator = userIds.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                int userId = iterator.next();
                if (Thread.interrupted()) {
                    return;
                }
                User user = this._userDao.getUserForId(userId);
                if (user != null) {
                    this._userDao.deleteUser(user);
                }
                Thread.yield();
            }
            break;
        }
        return;
    }

    private class DeleteStaleUsersTask
    implements Runnable {
        private Date _lastAccessTime;

        public DeleteStaleUsersTask(Date lastAccessTime) {
            this._lastAccessTime = lastAccessTime;
        }

        @Override
        public void run() {
            UserServiceImpl.this.deleteStaleUsers(this._lastAccessTime);
        }
    }
}

