/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.onebusaway.everylastlogin.server.AuthenticationResult;
import org.onebusaway.everylastlogin.server.LoginManager;
import org.onebusaway.users.impl.authentication.DefaultUserAuthenticationToken;
import org.onebusaway.users.impl.authentication.EveryLastLoginAuthenticationException;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.services.CurrentUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class EveryLastLoginAuthenticationProcessorFilter
extends AbstractAuthenticationProcessingFilter {
    private CurrentUserService _currentUserService;

    protected EveryLastLoginAuthenticationProcessorFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
    }

    @Autowired
    public void setCurrentUserService(CurrentUserService currentUserService) {
        this._currentUserService = currentUserService;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        String mode = request.getParameter("mode");
        AuthenticationResult result = LoginManager.getResult((HttpServletRequest)request);
        if (result == null) {
            throw new EveryLastLoginAuthenticationException("AuthenticationResult not found", mode);
        }
        if (result.getCode() != AuthenticationResult.EResultCode.SUCCESS) {
            throw new EveryLastLoginAuthenticationException("AuthenticationResult failure", mode);
        }
        IndexedUserDetails details = this._currentUserService.handleUserAction(result.getProvider(), result.getIdentity(), result.getCredentials(), false, mode);
        if (details == null) {
            throw new EveryLastLoginAuthenticationException("could not get user details", mode);
        }
        return new DefaultUserAuthenticationToken(details);
    }

    public void setSuccessHandler(AuthenticationSuccessHandler successHandler) {
        super.setAuthenticationSuccessHandler(successHandler);
    }

    public void setFailureHandler(AuthenticationFailureHandler failureHandler) {
        super.setAuthenticationFailureHandler(failureHandler);
    }

    public AuthenticationSuccessHandler getSuccessHandler() {
        return super.getSuccessHandler();
    }

    public AuthenticationFailureHandler getFailureHandler() {
        return super.getFailureHandler();
    }
}

