/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl.authentication;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.onebusaway.users.impl.authentication.EveryLastLoginAuthenticationException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class LoginAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private static String DEFAULT_FAILURE_URL = "/login.action?failure=true";
    private String failureUrl;

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    protected String determineFailureUrl(HttpServletRequest request, AuthenticationException failed) {
        if (this.failureUrl == null) {
            return DEFAULT_FAILURE_URL;
        }
        return this.failureUrl;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        EveryLastLoginAuthenticationException ex;
        String mode;
        Object failureUrl = this.determineFailureUrl(request, failed);
        if (failed instanceof EveryLastLoginAuthenticationException && (mode = (ex = (EveryLastLoginAuthenticationException)failed).getMode()) != null) {
            String prefix = "?";
            if (((String)failureUrl).contains(prefix)) {
                prefix = "&";
            }
            try {
                failureUrl = (String)failureUrl + prefix + "mode=" + URLEncoder.encode(mode, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        response.sendRedirect(request.getContextPath() + (String)failureUrl);
    }
}

