/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.impl.authentication;

import org.onebusaway.users.impl.authentication.LegacyPasswordEncoder;
import org.springframework.dao.DataAccessException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class VersionedPasswordEncoder
implements PasswordEncoder {
    private static final String DEFAULT_SEPARATOR_CHARACTER = "|";
    private String _versionId;
    private LegacyPasswordEncoder _passwordEncoder;
    private String _separatorCharacter = "|";

    public void setVersionId(String versionId) {
        this._versionId = versionId;
    }

    public void setPasswordEncoder(LegacyPasswordEncoder passwordEncoder) {
        this._passwordEncoder = passwordEncoder;
    }

    public String encodePassword(String rawPass, Object salt) throws DataAccessException {
        return this._versionId + this._separatorCharacter + this._passwordEncoder.encodePassword(rawPass, salt);
    }

    public String encode(CharSequence charSequence) {
        throw new UnsupportedOperationException("Please use encodePassword");
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        int index = encodedPassword.indexOf(this._separatorCharacter);
        if (index == -1) {
            return false;
        }
        encodedPassword = encodedPassword.substring(index + 1);
        return this._passwordEncoder.matches(rawPassword, encodedPassword);
    }

    public boolean upgradeEncoding(String encodedPassword) {
        return super.upgradeEncoding(encodedPassword);
    }
}

