/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class UserIndexKey
implements Serializable,
Comparable<UserIndexKey> {
    private static final long serialVersionUID = 1L;
    @Column(columnDefinition="VARCHAR(50)")
    private String type;
    @Column(columnDefinition="VARCHAR(200)")
    private String value;

    public UserIndexKey() {
    }

    public UserIndexKey(String type, String value) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (type.indexOf(95) != -1) {
            throw new IllegalArgumentException("type cannot contain \"_\" character");
        }
        this.type = type;
        this.value = value;
    }

    public static UserIndexKey parseString(String userIndexKey) {
        int index = userIndexKey.indexOf(95);
        if (index == -1) {
            throw new IllegalArgumentException("invalid UserIndexKey: " + userIndexKey);
        }
        String type = userIndexKey.substring(0, index);
        String value = userIndexKey.substring(index + 1);
        return new UserIndexKey(type, value);
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(UserIndexKey o) {
        int c = this.type.compareTo(o.type);
        if (c == 0) {
            c = this.value.compareTo(o.value);
        }
        return c;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIndexKey)) {
            return false;
        }
        UserIndexKey other = (UserIndexKey)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.type + "_" + this.value;
    }
}

