/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.users.services;

import java.util.List;
import org.onebusaway.users.client.model.UserBean;
import org.onebusaway.users.model.User;
import org.onebusaway.users.model.UserIndex;
import org.onebusaway.users.model.UserIndexKey;
import org.onebusaway.users.services.UserPropertiesMigrationStatus;

public interface UserService {
    public int getNumberOfUsers();

    public List<Integer> getAllUserIds();

    public List<Integer> getAllUserIdsInRange(int var1, int var2);

    public User getUserForId(int var1);

    public int getNumberOfAdmins();

    public List<String> getUserIndexKeyValuesForKeyType(String var1);

    public Integer getApiKeyCount();

    public List<User> getApiKeys(int var1, int var2);

    public UserIndex getUserIndexForId(UserIndexKey var1);

    public UserIndex getUserIndexForUsername(String var1);

    public UserIndex getOrCreateUserForIndexKey(UserIndexKey var1, String var2, boolean var3);

    public UserIndex getOrCreateUserForUsernameAndPassword(String var1, String var2);

    public UserIndex addUserIndexToUser(User var1, UserIndexKey var2, String var3);

    public void removeUserIndexForUser(User var1, UserIndexKey var2);

    public void setCredentialsForUserIndex(UserIndex var1, String var2);

    public void setPasswordForUsernameUserIndex(UserIndex var1, String var2);

    public UserBean getUserAsBean(User var1);

    public UserBean getAnonymousUser();

    public void deleteUser(User var1);

    public void resetUser(User var1);

    public boolean isAnonymous(User var1);

    public boolean isAdministrator(User var1);

    public void enableAdminRoleForUser(User var1, boolean var2);

    public void disableAdminRoleForUser(User var1, boolean var2);

    public void mergeUsers(User var1, User var2);

    public void startUserPropertiesMigration();

    public UserPropertiesMigrationStatus getUserPropertiesMigrationStatus();

    public String registerPhoneNumber(User var1, String var2);

    public boolean hasPhoneNumberRegistration(UserIndexKey var1);

    public UserIndex completePhoneNumberRegistration(UserIndex var1, String var2);

    public void clearPhoneNumberRegistration(UserIndexKey var1);

    public Long getMinApiRequestIntervalForKey(String var1, boolean var2);

    public void deleteStaleUsers();

    public boolean isDeletingStaleUsers();

    public void cancelDeleteStaleUsers();

    public long getNumberOfStaleUsers();
}

