/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.alarms;

import com.amazonaws.services.cloudwatch.model.ComparisonOperator;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Collection;
import org.onebusaway.aws.monitoring.impl.alarms.AlarmsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.alarms.AdminServerAlarms;
import org.springframework.stereotype.Component;

@Component
public class AdminServiceAlarmsImpl
extends AlarmsTemplate
implements AdminServerAlarms {
    public void createCurrentBundleCountAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.CurrentBundleCount);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.bundleCount", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createFirstValidBundleFilesCountAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.FirstValidBundleFilesCount);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.bundleFilesCount", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }
}

