/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.alarms;

import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import java.util.Collection;
import org.onebusaway.aws.monitoring.impl.alarms.AlarmsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.alarms.GtfsRtAlarms;
import org.springframework.stereotype.Component;

@Component
public class GtfsRtAlarmsImpl
extends AlarmsTemplate
implements GtfsRtAlarms {
    public void createMessagesSentAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getSQSMetricAlarmRequest(MetricName.NumberOfMessagesSent, this.getSqsQueue());
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.sqsNumMessagesSent", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createMessagesReceivedAlarm() {
        String sqsQueue = this._configService.getConfigurationValueAsString("alarm.sqsQueue", this.getEnv());
        PutMetricAlarmRequest putMetricAlarmRequest = this.getSQSMetricAlarmRequest(MetricName.NumberOfMessagesReceived, this.getSqsQueue());
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.sqsNumMessagesReceived", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createMessagesDeletedAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getSQSMetricAlarmRequest(MetricName.NumberOfMessagesDeleted, this.getSqsQueue());
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.sqsNumMessagesDeleted", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createMessagesSizeAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getSQSMetricAlarmRequest(MetricName.SentMessageSize, this.getSqsQueue());
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.sqsSentMessageSize", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createMessagesDelayedAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getSQSMetricAlarmRequest(MetricName.NumberOfMessagesDelayed, this.getSqsQueue());
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.sqsNumMessagesDelayed", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }
}

