/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.alarms;

import com.amazonaws.services.cloudwatch.model.ComparisonOperator;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Collection;
import org.onebusaway.aws.monitoring.impl.alarms.AlarmsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.alarms.PredictionAlarms;
import org.springframework.stereotype.Component;

@Component
public class PredictionAlarmsImpl
extends AlarmsTemplate
implements PredictionAlarms {
    public void createDeserializeQueueSizeAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.PredictionDeserializeQueueSize);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.predictionDeserializeQueueSize", Double.valueOf(1000.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createProcessingTimeAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.PredictionProcessingTime);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.predictionProcessingTime", Double.valueOf(100.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createPredictionTotalLatencyAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.PredictionTotalLatency);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.predictionTotalLatency", Double.valueOf(30000.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createPredictionTotalQueueLatencyAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.PredictionTotalQueueLatency);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.predictionTotalQueueLatency", Double.valueOf(30000.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createPredictablePercentageAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.PredictionPredictablePercentage);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setInsufficientDataActions((Collection)this.getNonCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setComparisonOperator(ComparisonOperator.LessThanOrEqualToThreshold);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.predictionProcessingTime", Double.valueOf(0.3)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }
}

