/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.alarms;

import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Collection;
import org.onebusaway.aws.monitoring.impl.alarms.AlarmsTemplate;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.alarms.WebappAlarms;
import org.springframework.stereotype.Component;

@Component
public class WebappAlarmsImpl
extends AlarmsTemplate
implements WebappAlarms {
    public void createDesktopUiValidAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.DesktopUiValid);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.webDesktopUiValid", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createVehicleMonitoringAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.VehicleMonitoringErrorResponse);
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.webVehicleMonitoringError", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createStopMonitoringAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.StopMonitoringErrorResponse);
        putMetricAlarmRequest.setThreshold(Double.valueOf(1.0));
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.webStopMonitoringError", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createNextBusApiAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.NextBusApiErrorResponse);
        putMetricAlarmRequest.setThreshold(Double.valueOf(1.0));
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.webNextBusApiError", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }

    public void createSmsApiAlarm() {
        PutMetricAlarmRequest putMetricAlarmRequest = this.getMetricAlarmRequest(MetricName.SMSWebappErrorResponse);
        putMetricAlarmRequest.setThreshold(Double.valueOf(1.0));
        putMetricAlarmRequest.setAlarmActions((Collection)this.getCriticalAction());
        putMetricAlarmRequest.setUnit(StandardUnit.Count);
        putMetricAlarmRequest.setThreshold(this._configService.getConfigurationValueAsDouble("alarm.webSMSWebappError", Double.valueOf(1.0)));
        this._cloudWatchService.publishAlarm(putMetricAlarmRequest);
    }
}

