/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.metrics;

import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.onebusaway.aws.monitoring.impl.metrics.MetricsTemplate;
import org.onebusaway.aws.monitoring.impl.metrics.WebappMetricsImpl;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.service.metrics.AdminServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class AdminServerMetricsImpl
extends MetricsTemplate
implements AdminServerMetrics,
ApplicationListener<ContextRefreshedEvent> {
    protected static final Logger _log = LoggerFactory.getLogger(WebappMetricsImpl.class);
    private static String admin_api_url = "";

    public void reloadConfig() {
        admin_api_url = this._configurationService.getConfigurationValueAsString("monitoring.adminApiUrl", "");
    }

    public void publishBundleCountMetrics() {
        double metric = 0.0;
        String bundleListUrl = admin_api_url + "bundle/list";
        try {
            JsonObject bundleList = this.getJsonObject(bundleListUrl);
            JsonArray bundles = bundleList.getAsJsonArray("bundles");
            for (JsonElement bundleElement : bundles) {
                if (metric == 0.0) {
                    try {
                        JsonObject bundle = bundleElement.getAsJsonObject();
                        Date today = new Date();
                        Date dateFrom = new SimpleDateFormat("yyyy-MM-dd").parse(bundle.get("service-date-from").getAsString());
                        Date dateTo = new SimpleDateFormat("yyyy-MM-dd").parse(bundle.get("service-date-to").getAsString());
                        if (dateFrom.compareTo(today) <= 0 && dateTo.compareTo(today) >= 0) {
                            JsonArray files = bundle.getAsJsonArray("files");
                            double numberOfFiles = files == null ? 0.0 : (double)files.size();
                            this.publishMetric(MetricName.FirstValidBundleFilesCount, StandardUnit.Count, Double.valueOf(numberOfFiles));
                        }
                    }
                    catch (NullPointerException npe) {
                        _log.error("Unable to retreive the bundle start and end dates for bundle " + metric + "1");
                    }
                    catch (ParseException pe) {
                        _log.error("Unable to parse the bundle start and end dates for bundle " + metric + "1");
                    }
                }
                metric += 1.0;
            }
            this.publishMetric(MetricName.CurrentBundleCount, StandardUnit.Count, Double.valueOf(metric));
        }
        catch (MalformedURLException mue) {
            _log.error(mue.getMessage());
            return;
        }
        catch (IOException ioe) {
            _log.warn("Error communicating with specified url : " + bundleListUrl);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.reloadConfig();
    }
}

