/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.aws.monitoring.impl.metrics;

import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Date;
import org.onebusaway.aws.cloudwatch.service.CloudwatchService;
import org.onebusaway.aws.monitoring.model.metrics.Metric;
import org.onebusaway.aws.monitoring.model.metrics.MetricName;
import org.onebusaway.aws.monitoring.model.metrics.MetricResponse;
import org.onebusaway.util.SystemTime;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class MetricsTemplate {
    protected static final Logger _log = LoggerFactory.getLogger(MetricsTemplate.class);
    protected static final int CONNECTION_TIMEOUT = 3000;
    @Autowired
    CloudwatchService _cloudWatchService;
    @Autowired
    ConfigurationService _configurationService;

    public JsonObject getJsonObject(String uri) throws MalformedURLException, IOException, SocketTimeoutException {
        HttpURLConnection con = null;
        try {
            JsonObject rootobj;
            URL url = new URL(uri);
            con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(3000);
            con.setReadTimeout(3000);
            con.connect();
            JsonParser jp = new JsonParser();
            JsonElement root = jp.parse((Reader)new InputStreamReader((InputStream)con.getContent()));
            JsonObject jsonObject = rootobj = root.getAsJsonObject();
            return jsonObject;
        }
        catch (MalformedURLException mue) {
            _log.warn(mue.getMessage());
            throw mue;
        }
        catch (SocketTimeoutException ste) {
            _log.warn("Connection to url : " + uri + " timed out after 3 sec");
            throw ste;
        }
        catch (IOException ioe) {
            _log.warn("Error communicating with specified url : " + uri);
            throw ioe;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public MetricDatum getMetricDatum(String metricName, Double value, StandardUnit unit) {
        return new MetricDatum().withMetricName(metricName).withTimestamp(new Date()).withValue(value).withUnit(unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricResponse getUrlWithResponseTime(String url) {
        double metric;
        long startTime = SystemTime.currentTimeMillis();
        HttpURLConnection con = null;
        try {
            URL obj = new URL(url);
            con = (HttpURLConnection)obj.openConnection();
            con.setConnectTimeout(3000);
            con.setReadTimeout(3000);
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while (in.readLine() != null) {
                }
                in.close();
                metric = 0.0;
            } else {
                metric = 1.0;
            }
        }
        catch (SocketTimeoutException e) {
            _log.warn("Connection to url : " + url + " timed out after 3 sec");
            metric = 1.0;
        }
        catch (IOException ioe) {
            _log.warn("Error communicating with specified url : " + url);
            metric = 1.0;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return new MetricResponse(Double.valueOf(metric), Double.valueOf(SystemTime.currentTimeMillis() - startTime));
    }

    public String getUrlResponse(String url) {
        try {
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                StringBuffer response = new StringBuffer();
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                return response.toString();
            }
        }
        catch (IOException ioe) {
            _log.warn("Error communicating with specified url : " + url);
        }
        return null;
    }

    public void publishWatchdogMetric(String url, MetricName metricName, StandardUnit unit) {
        try {
            JsonObject json = this.getJsonObject(url);
            if (json != null) {
                Gson gson = new Gson();
                Metric metric = (Metric)gson.fromJson((JsonElement)json, Metric.class);
                this.publishMetric(metricName, StandardUnit.Count, Double.valueOf(metric.getMetricValue().toString()));
            }
        }
        catch (MalformedURLException mue) {
            _log.error(mue.getMessage());
            return;
        }
        catch (IOException ioe) {
            _log.warn("Error communicating with specified url : " + url);
        }
        catch (NumberFormatException nfe) {
            _log.error("Unable to convert metric " + metricName + " to a Double value");
        }
        catch (Exception e) {
            _log.error("Error retreiving Watchdog Metric");
        }
    }

    public void publishMetric(MetricName metricName, StandardUnit unit, Double metric) {
        this._cloudWatchService.publishMetric(metricName.toString(), unit, metric);
    }
}

